// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for invoking a Lambda function in Lambda to alter document metadata and content when ingesting documents into Amazon Kendra. You can configure your Lambda function using [PreExtractionHookConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html) if you want to apply advanced alterations on the original or raw documents. If you want to apply advanced alterations on the Amazon Kendra structured documents, you must configure your Lambda function using [PostExtractionHookConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html). You can only invoke one Lambda function. However, this function can invoke other functions it requires.
 *
 * For more information, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
 */
class HookConfiguration private constructor(builder: Builder) {
    /**
     * The condition used for when a Lambda function should be invoked.
     *
     * For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.
     */
    val invocationCondition: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition? = builder.invocationCondition
    /**
     * The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    val lambdaArn: kotlin.String? = builder.lambdaArn
    /**
     * Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
     */
    val s3Bucket: kotlin.String? = builder.s3Bucket

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.HookConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HookConfiguration(")
        append("invocationCondition=$invocationCondition,")
        append("lambdaArn=$lambdaArn,")
        append("s3Bucket=$s3Bucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = invocationCondition?.hashCode() ?: 0
        result = 31 * result + (lambdaArn?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HookConfiguration

        if (invocationCondition != other.invocationCondition) return false
        if (lambdaArn != other.lambdaArn) return false
        if (s3Bucket != other.s3Bucket) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.HookConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The condition used for when a Lambda function should be invoked.
         *
         * For example, you can specify a condition that if there are empty date-time values, then Amazon Kendra should invoke a function that inserts the current date-time.
         */
        var invocationCondition: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition? = null
        /**
         * The Amazon Resource Name (ARN) of a role with permission to run a Lambda function during ingestion. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        var lambdaArn: kotlin.String? = null
        /**
         * Stores the original, raw documents or the structured, parsed documents before and after altering them. For more information, see [Data contracts for Lambda functions](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
         */
        var s3Bucket: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.HookConfiguration) : this() {
            this.invocationCondition = x.invocationCondition
            this.lambdaArn = x.lambdaArn
            this.s3Bucket = x.s3Bucket
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.HookConfiguration = HookConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition] inside the given [block]
         */
        fun invocationCondition(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition.Builder.() -> kotlin.Unit) {
            this.invocationCondition = aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition.invoke(block)
        }
    }
}
