// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for applying basic logic to alter document metadata and content when ingesting documents into Amazon Kendra. To apply advanced logic, to go beyond what you can do with basic logic, see [HookConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html).
 *
 * For more information, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
 */
class InlineCustomDocumentEnrichmentConfiguration private constructor(builder: Builder) {
    /**
     * Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
     */
    val condition: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition? = builder.condition
    /**
     * `TRUE` to delete content if the condition used for the target attribute is met.
     */
    val documentContentDeletion: kotlin.Boolean = builder.documentContentDeletion
    /**
     * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value.
     */
    val target: aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InlineCustomDocumentEnrichmentConfiguration(")
        append("condition=$condition,")
        append("documentContentDeletion=$documentContentDeletion,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (documentContentDeletion.hashCode())
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InlineCustomDocumentEnrichmentConfiguration

        if (condition != other.condition) return false
        if (documentContentDeletion != other.documentContentDeletion) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration of the condition used for the target document attribute or metadata field when ingesting documents into Amazon Kendra.
         */
        var condition: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition? = null
        /**
         * `TRUE` to delete content if the condition used for the target attribute is met.
         */
        var documentContentDeletion: kotlin.Boolean = false
        /**
         * Configuration of the target document attribute or metadata field when ingesting documents into Amazon Kendra. You can also include a value.
         */
        var target: aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration) : this() {
            this.condition = x.condition
            this.documentContentDeletion = x.documentContentDeletion
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.InlineCustomDocumentEnrichmentConfiguration = InlineCustomDocumentEnrichmentConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition] inside the given [block]
         */
        fun condition(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition.Builder.() -> kotlin.Unit) {
            this.condition = aws.sdk.kotlin.services.kendra.model.DocumentAttributeCondition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget] inside the given [block]
         */
        fun target(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget.invoke(block)
        }
    }
}
