// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Jira as your data source.
 */
class JiraConfiguration private constructor(builder: Builder) {
    /**
     * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira attachments to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    val attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.attachmentFieldMappings
    /**
     * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira comments to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    val commentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.commentFieldMappings
    /**
     * A list of regular expression patterns to exclude certain file paths, file names, and file types in your Jira data source. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of regular expression patterns to include certain file paths, file names, and file types in your Jira data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira issues to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    val issueFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.issueFieldMappings
    /**
     * Specify whether to crawl comments, attachments, and work logs. You can specify one or more of these options.
     */
    val issueSubEntityFilter: List<IssueSubEntity>? = builder.issueSubEntityFilter
    /**
     * Specify which issue types to crawl in your Jira data source. You can specify one or more of these options to crawl.
     */
    val issueType: List<String>? = builder.issueType
    /**
     * The URL of the Jira account. For example, company.attlassian.net or https://jira.company.com. You can find your Jira account URL in the URL of your profile page for Jira desktop.
     */
    val jiraAccountUrl: kotlin.String? = builder.jiraAccountUrl
    /**
     * Specify which projects to crawl in your Jira data source. You can specify one or more Jira project IDs.
     */
    val project: List<String>? = builder.project
    /**
     * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira projects to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    val projectFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.projectFieldMappings
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Jira data source. The secret must contain a JSON structure with the following keys:
     * + jira-id—The ID of the Jira account.
     * + jiraCredentials—The password of the Jira account user.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * Specify which statuses to crawl in your Jira data source. You can specify one or more of these options to crawl.
     */
    val status: List<String>? = builder.status
    /**
     * Specify to use the change log option to update your index.
     */
    val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Jira. Your Jira account must reside inside your VPC.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration
    /**
     * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira work logs to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
     */
    val workLogFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.workLogFieldMappings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JiraConfiguration(")
        append("attachmentFieldMappings=$attachmentFieldMappings,")
        append("commentFieldMappings=$commentFieldMappings,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("issueFieldMappings=$issueFieldMappings,")
        append("issueSubEntityFilter=$issueSubEntityFilter,")
        append("issueType=$issueType,")
        append("jiraAccountUrl=$jiraAccountUrl,")
        append("project=$project,")
        append("projectFieldMappings=$projectFieldMappings,")
        append("secretArn=$secretArn,")
        append("status=$status,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("workLogFieldMappings=$workLogFieldMappings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (commentFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (issueFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (issueSubEntityFilter?.hashCode() ?: 0)
        result = 31 * result + (issueType?.hashCode() ?: 0)
        result = 31 * result + (jiraAccountUrl?.hashCode() ?: 0)
        result = 31 * result + (project?.hashCode() ?: 0)
        result = 31 * result + (projectFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workLogFieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JiraConfiguration

        if (attachmentFieldMappings != other.attachmentFieldMappings) return false
        if (commentFieldMappings != other.commentFieldMappings) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (issueFieldMappings != other.issueFieldMappings) return false
        if (issueSubEntityFilter != other.issueSubEntityFilter) return false
        if (issueType != other.issueType) return false
        if (jiraAccountUrl != other.jiraAccountUrl) return false
        if (project != other.project) return false
        if (projectFieldMappings != other.projectFieldMappings) return false
        if (secretArn != other.secretArn) return false
        if (status != other.status) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (workLogFieldMappings != other.workLogFieldMappings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira attachments to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        var attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira comments to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        var commentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to exclude certain file paths, file names, and file types in your Jira data source. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain file paths, file names, and file types in your Jira data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira issues to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        var issueFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Specify whether to crawl comments, attachments, and work logs. You can specify one or more of these options.
         */
        var issueSubEntityFilter: List<IssueSubEntity>? = null
        /**
         * Specify which issue types to crawl in your Jira data source. You can specify one or more of these options to crawl.
         */
        var issueType: List<String>? = null
        /**
         * The URL of the Jira account. For example, company.attlassian.net or https://jira.company.com. You can find your Jira account URL in the URL of your profile page for Jira desktop.
         */
        var jiraAccountUrl: kotlin.String? = null
        /**
         * Specify which projects to crawl in your Jira data source. You can specify one or more Jira project IDs.
         */
        var project: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira projects to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        var projectFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Jira data source. The secret must contain a JSON structure with the following keys:
         * + jira-id—The ID of the Jira account.
         * + jiraCredentials—The password of the Jira account user.
         */
        var secretArn: kotlin.String? = null
        /**
         * Specify which statuses to crawl in your Jira data source. You can specify one or more of these options to crawl.
         */
        var status: List<String>? = null
        /**
         * Specify to use the change log option to update your index.
         */
        var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Jira. Your Jira account must reside inside your VPC.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that map attributes or field names of Jira work logs to Amazon Kendra index field names. To create custom fields, use the UpdateIndex API before you map to Jira fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Jira data source field names must exist in your Jira custom metadata.
         */
        var workLogFieldMappings: List<DataSourceToIndexFieldMapping>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.JiraConfiguration) : this() {
            this.attachmentFieldMappings = x.attachmentFieldMappings
            this.commentFieldMappings = x.commentFieldMappings
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.issueFieldMappings = x.issueFieldMappings
            this.issueSubEntityFilter = x.issueSubEntityFilter
            this.issueType = x.issueType
            this.jiraAccountUrl = x.jiraAccountUrl
            this.project = x.project
            this.projectFieldMappings = x.projectFieldMappings
            this.secretArn = x.secretArn
            this.status = x.status
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
            this.workLogFieldMappings = x.workLogFieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.JiraConfiguration = JiraConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
