// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for users or groups in your Amazon Web Services SSO identity source. This applies to users and groups with specific permissions that define their level of access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
class PersonasSummary private constructor(builder: Builder) {
    /**
     * The date-time the summary information was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID could be an email.
     */
    val entityId: kotlin.String? = builder.entityId
    /**
     * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO identity source. The available personas or access roles are `Owner` and `Viewer`. For more information on these personas, see [Providing access to your search page](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
     */
    val persona: aws.sdk.kotlin.services.kendra.model.Persona? = builder.persona
    /**
     * The date-time the summary information was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.PersonasSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PersonasSummary(")
        append("createdAt=$createdAt,")
        append("entityId=$entityId,")
        append("persona=$persona,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (persona?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PersonasSummary

        if (createdAt != other.createdAt) return false
        if (entityId != other.entityId) return false
        if (persona != other.persona) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.PersonasSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date-time the summary information was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a user or group in your Amazon Web Services SSO identity source. For example, a user ID could be an email.
         */
        var entityId: kotlin.String? = null
        /**
         * The persona that defines the specific permissions of the user or group in your Amazon Web Services SSO identity source. The available personas or access roles are `Owner` and `Viewer`. For more information on these personas, see [Providing access to your search page](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
         */
        var persona: aws.sdk.kotlin.services.kendra.model.Persona? = null
        /**
         * The date-time the summary information was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.PersonasSummary) : this() {
            this.createdAt = x.createdAt
            this.entityId = x.entityId
            this.persona = x.persona
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.PersonasSummary = PersonasSummary(this)
    }
}
