// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class PutPrincipalMappingRequest private constructor(builder: Builder) {
    /**
     * The identifier of the data source you want to map users to their groups.
     *
     * This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
     */
    val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The identifier of the group you want to map its users to.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The list that contains your users or sub groups that belong the same group.
     *
     * For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
     *
     * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.
     */
    val groupMembers: aws.sdk.kotlin.services.kendra.model.GroupMembers? = builder.groupMembers
    /**
     * The identifier of the index you want to map users to their groups.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest `PUT` action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.
     *
     * The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling `PutPrincipalMapping`. This ensures your `PUT` action for that updated group with the latest members list doesn't get overwritten by earlier `PUT` actions for the same group which are yet to be processed.
     *
     * The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.
     */
    val orderingId: kotlin.Long? = builder.orderingId
    /**
     * The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.
     *
     * For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds).
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPrincipalMappingRequest(")
        append("dataSourceId=$dataSourceId,")
        append("groupId=$groupId,")
        append("groupMembers=$groupMembers,")
        append("indexId=$indexId,")
        append("orderingId=$orderingId,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupMembers?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (orderingId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPrincipalMappingRequest

        if (dataSourceId != other.dataSourceId) return false
        if (groupId != other.groupId) return false
        if (groupMembers != other.groupMembers) return false
        if (indexId != other.indexId) return false
        if (orderingId != other.orderingId) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the data source you want to map users to their groups.
         *
         * This is useful if a group is tied to multiple data sources, but you only want the group to access documents of a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. However, "Sales and Marketing" team only needs access to customer-related documents stored in Salesforce.
         */
        var dataSourceId: kotlin.String? = null
        /**
         * The identifier of the group you want to map its users to.
         */
        var groupId: kotlin.String? = null
        /**
         * The list that contains your users or sub groups that belong the same group.
         *
         * For example, the group "Company" includes the user "CEO" and the sub groups "Research", "Engineering", and "Sales and Marketing".
         *
         * If you have more than 1000 users and/or sub groups for a single group, you need to provide the path to the S3 file that lists your users and sub groups for a group. Your sub groups can contain more than 1000 users, but the list of sub groups that belong to a group (and/or users) must be no more than 1000.
         */
        var groupMembers: aws.sdk.kotlin.services.kendra.model.GroupMembers? = null
        /**
         * The identifier of the index you want to map users to their groups.
         */
        var indexId: kotlin.String? = null
        /**
         * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest `PUT` action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.
         *
         * The ordering ID can be the UNIX time of the last update you made to a group members list. You would then provide this list when calling `PutPrincipalMapping`. This ensures your `PUT` action for that updated group with the latest members list doesn't get overwritten by earlier `PUT` actions for the same group which are yet to be processed.
         *
         * The default ordering ID is the current UNIX time in milliseconds that the action was received by Amazon Kendra.
         */
        var orderingId: kotlin.Long? = null
        /**
         * The Amazon Resource Name (ARN) of a role that has access to the S3 file that contains your list of users or sub groups that belong to a group.
         *
         * For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-ds).
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingRequest) : this() {
            this.dataSourceId = x.dataSourceId
            this.groupId = x.groupId
            this.groupMembers = x.groupMembers
            this.indexId = x.indexId
            this.orderingId = x.orderingId
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingRequest = PutPrincipalMappingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.GroupMembers] inside the given [block]
         */
        fun groupMembers(block: aws.sdk.kotlin.services.kendra.model.GroupMembers.Builder.() -> kotlin.Unit) {
            this.groupMembers = aws.sdk.kotlin.services.kendra.model.GroupMembers.invoke(block)
        }
    }
}
