// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class QueryRequest private constructor(builder: Builder) {
    /**
     * Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
     *
     * The `AttributeFilter` parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.
     */
    val attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = builder.attributeFilter
    /**
     * Overrides relevance tuning configurations of fields or attributes set at the index level.
     *
     * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
     *
     * If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.
     *
     * If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
     */
    val documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = builder.documentRelevanceOverrideConfigurations
    /**
     * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. This helps your users narrow their search.
     */
    val facets: List<Facet>? = builder.facets
    /**
     * The unique identifier of the index to search. The identifier is returned in the response from the `CreateIndex` API.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * Query results are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
     */
    val pageNumber: kotlin.Int? = builder.pageNumber
    /**
     * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
     */
    val pageSize: kotlin.Int? = builder.pageSize
    /**
     * Sets the type of query. Only results for the specified query type are returned.
     */
    val queryResultTypeFilter: aws.sdk.kotlin.services.kendra.model.QueryResultType? = builder.queryResultTypeFilter
    /**
     * The text to search for.
     */
    val queryText: kotlin.String? = builder.queryText
    /**
     * An array of document attributes to include in the response. You can limit the response to include certain document attributes. By default all document attributes are included in the response.
     */
    val requestedDocumentAttributes: List<String>? = builder.requestedDocumentAttributes
    /**
     * Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.
     *
     * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.
     */
    val sortingConfiguration: aws.sdk.kotlin.services.kendra.model.SortingConfiguration? = builder.sortingConfiguration
    /**
     * Enables suggested spell corrections for queries.
     */
    val spellCorrectionConfiguration: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration? = builder.spellCorrectionConfiguration
    /**
     * The user context token or user and group information.
     */
    val userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = builder.userContext
    /**
     * Provides an identifier for a specific user. The `VisitorId` should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the `VisitorId`.
     */
    val visitorId: kotlin.String? = builder.visitorId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryRequest(")
        append("attributeFilter=$attributeFilter,")
        append("documentRelevanceOverrideConfigurations=$documentRelevanceOverrideConfigurations,")
        append("facets=$facets,")
        append("indexId=$indexId,")
        append("pageNumber=$pageNumber,")
        append("pageSize=$pageSize,")
        append("queryResultTypeFilter=$queryResultTypeFilter,")
        append("queryText=$queryText,")
        append("requestedDocumentAttributes=$requestedDocumentAttributes,")
        append("sortingConfiguration=$sortingConfiguration,")
        append("spellCorrectionConfiguration=$spellCorrectionConfiguration,")
        append("userContext=$userContext,")
        append("visitorId=$visitorId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeFilter?.hashCode() ?: 0
        result = 31 * result + (documentRelevanceOverrideConfigurations?.hashCode() ?: 0)
        result = 31 * result + (facets?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (pageNumber ?: 0)
        result = 31 * result + (pageSize ?: 0)
        result = 31 * result + (queryResultTypeFilter?.hashCode() ?: 0)
        result = 31 * result + (queryText?.hashCode() ?: 0)
        result = 31 * result + (requestedDocumentAttributes?.hashCode() ?: 0)
        result = 31 * result + (sortingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (spellCorrectionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userContext?.hashCode() ?: 0)
        result = 31 * result + (visitorId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryRequest

        if (attributeFilter != other.attributeFilter) return false
        if (documentRelevanceOverrideConfigurations != other.documentRelevanceOverrideConfigurations) return false
        if (facets != other.facets) return false
        if (indexId != other.indexId) return false
        if (pageNumber != other.pageNumber) return false
        if (pageSize != other.pageSize) return false
        if (queryResultTypeFilter != other.queryResultTypeFilter) return false
        if (queryText != other.queryText) return false
        if (requestedDocumentAttributes != other.requestedDocumentAttributes) return false
        if (sortingConfiguration != other.sortingConfiguration) return false
        if (spellCorrectionConfiguration != other.spellCorrectionConfiguration) return false
        if (userContext != other.userContext) return false
        if (visitorId != other.visitorId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Enables filtered searches based on document attributes. You can only provide one attribute filter; however, the `AndAllFilters`, `NotFilter`, and `OrAllFilters` parameters contain a list of other filters.
         *
         * The `AttributeFilter` parameter enables you to create a set of filtering rules that a document must satisfy to be included in the query results.
         */
        var attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = null
        /**
         * Overrides relevance tuning configurations of fields or attributes set at the index level.
         *
         * If you use this API to override the relevance tuning configured at the index level, but there is no relevance tuning configured at the index level, then Amazon Kendra does not apply any relevance tuning.
         *
         * If there is relevance tuning configured at the index level, but you do not use this API to override any relevance tuning in the index, then Amazon Kendra uses the relevance tuning that is configured at the index level.
         *
         * If there is relevance tuning configured for fields at the index level, but you use this API to override only some of these fields, then for the fields you did not override, the importance is set to 1.
         */
        var documentRelevanceOverrideConfigurations: List<DocumentRelevanceConfiguration>? = null
        /**
         * An array of documents attributes. Amazon Kendra returns a count for each attribute key specified. This helps your users narrow their search.
         */
        var facets: List<Facet>? = null
        /**
         * The unique identifier of the index to search. The identifier is returned in the response from the `CreateIndex` API.
         */
        var indexId: kotlin.String? = null
        /**
         * Query results are returned in pages the size of the `PageSize` parameter. By default, Amazon Kendra returns the first page of results. Use this parameter to get result pages after the first one.
         */
        var pageNumber: kotlin.Int? = null
        /**
         * Sets the number of results that are returned in each page of results. The default page size is 10. The maximum number of results returned is 100. If you ask for more than 100 results, only 100 are returned.
         */
        var pageSize: kotlin.Int? = null
        /**
         * Sets the type of query. Only results for the specified query type are returned.
         */
        var queryResultTypeFilter: aws.sdk.kotlin.services.kendra.model.QueryResultType? = null
        /**
         * The text to search for.
         */
        var queryText: kotlin.String? = null
        /**
         * An array of document attributes to include in the response. You can limit the response to include certain document attributes. By default all document attributes are included in the response.
         */
        var requestedDocumentAttributes: List<String>? = null
        /**
         * Provides information that determines how the results of the query are sorted. You can set the field that Amazon Kendra should sort the results on, and specify whether the results should be sorted in ascending or descending order. In the case of ties in sorting the results, the results are sorted by relevance.
         *
         * If you don't provide sorting configuration, the results are sorted by the relevance that Amazon Kendra determines for the result.
         */
        var sortingConfiguration: aws.sdk.kotlin.services.kendra.model.SortingConfiguration? = null
        /**
         * Enables suggested spell corrections for queries.
         */
        var spellCorrectionConfiguration: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration? = null
        /**
         * The user context token or user and group information.
         */
        var userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = null
        /**
         * Provides an identifier for a specific user. The `VisitorId` should be a unique identifier, such as a GUID. Don't use personally identifiable information, such as the user's email address, as the `VisitorId`.
         */
        var visitorId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryRequest) : this() {
            this.attributeFilter = x.attributeFilter
            this.documentRelevanceOverrideConfigurations = x.documentRelevanceOverrideConfigurations
            this.facets = x.facets
            this.indexId = x.indexId
            this.pageNumber = x.pageNumber
            this.pageSize = x.pageSize
            this.queryResultTypeFilter = x.queryResultTypeFilter
            this.queryText = x.queryText
            this.requestedDocumentAttributes = x.requestedDocumentAttributes
            this.sortingConfiguration = x.sortingConfiguration
            this.spellCorrectionConfiguration = x.spellCorrectionConfiguration
            this.userContext = x.userContext
            this.visitorId = x.visitorId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryRequest = QueryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeFilter] inside the given [block]
         */
        fun attributeFilter(block: aws.sdk.kotlin.services.kendra.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.kendra.model.AttributeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SortingConfiguration] inside the given [block]
         */
        fun sortingConfiguration(block: aws.sdk.kotlin.services.kendra.model.SortingConfiguration.Builder.() -> kotlin.Unit) {
            this.sortingConfiguration = aws.sdk.kotlin.services.kendra.model.SortingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration] inside the given [block]
         */
        fun spellCorrectionConfiguration(block: aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration.Builder.() -> kotlin.Unit) {
            this.spellCorrectionConfiguration = aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserContext] inside the given [block]
         */
        fun userContext(block: aws.sdk.kotlin.services.kendra.model.UserContext.Builder.() -> kotlin.Unit) {
            this.userContext = aws.sdk.kotlin.services.kendra.model.UserContext.invoke(block)
        }
    }
}
