// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Quip as your data source.
 */
class QuipConfiguration private constructor(builder: Builder) {
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
     */
    val attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.attachmentFieldMappings
    /**
     * Specify whether to crawl attachments in Quip. You can specify one or more of these options.
     */
    val crawlAttachments: kotlin.Boolean = builder.crawlAttachments
    /**
     * Specify whether to crawl chat rooms in Quip. You can specify one or more of these options.
     */
    val crawlChatRooms: kotlin.Boolean = builder.crawlChatRooms
    /**
     * Specify whether to crawl file comments in Quip. You can specify one or more of these options.
     */
    val crawlFileComments: kotlin.Boolean = builder.crawlFileComments
    /**
     * The Quip site domain.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * A list of regular expression patterns to exclude certain files in your Quip file system. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn't included in the index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * The identifier of the Quip folder IDs to index.
     */
    val folderIds: List<String>? = builder.folderIds
    /**
     * A list of regular expression patterns to include certain files in your Quip file system. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn't included in the index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip messages to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
     */
    val messageFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.messageFieldMappings
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs that are required to connect to your Quip. The secret must contain a JSON structure with the following keys:
     * + accessToken—The token created in Quip. For more information, see [Authentication for a Quip data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#quip-authentication).
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip threads to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
     */
    val threadFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.threadFieldMappings
    /**
     * Configuration information for an Amazon Virtual Private Cloud (VPC) to connect to your Quip. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QuipConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuipConfiguration(")
        append("attachmentFieldMappings=$attachmentFieldMappings,")
        append("crawlAttachments=$crawlAttachments,")
        append("crawlChatRooms=$crawlChatRooms,")
        append("crawlFileComments=$crawlFileComments,")
        append("domain=$domain,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("folderIds=$folderIds,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("messageFieldMappings=$messageFieldMappings,")
        append("secretArn=$secretArn,")
        append("threadFieldMappings=$threadFieldMappings,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (crawlAttachments.hashCode())
        result = 31 * result + (crawlChatRooms.hashCode())
        result = 31 * result + (crawlFileComments.hashCode())
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (folderIds?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (messageFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (threadFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuipConfiguration

        if (attachmentFieldMappings != other.attachmentFieldMappings) return false
        if (crawlAttachments != other.crawlAttachments) return false
        if (crawlChatRooms != other.crawlChatRooms) return false
        if (crawlFileComments != other.crawlFileComments) return false
        if (domain != other.domain) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (folderIds != other.folderIds) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (messageFieldMappings != other.messageFieldMappings) return false
        if (secretArn != other.secretArn) return false
        if (threadFieldMappings != other.threadFieldMappings) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QuipConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip attachments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
         */
        var attachmentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Specify whether to crawl attachments in Quip. You can specify one or more of these options.
         */
        var crawlAttachments: kotlin.Boolean = false
        /**
         * Specify whether to crawl chat rooms in Quip. You can specify one or more of these options.
         */
        var crawlChatRooms: kotlin.Boolean = false
        /**
         * Specify whether to crawl file comments in Quip. You can specify one or more of these options.
         */
        var crawlFileComments: kotlin.Boolean = false
        /**
         * The Quip site domain.
         */
        var domain: kotlin.String? = null
        /**
         * A list of regular expression patterns to exclude certain files in your Quip file system. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn't included in the index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * The identifier of the Quip folder IDs to index.
         */
        var folderIds: List<String>? = null
        /**
         * A list of regular expression patterns to include certain files in your Quip file system. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence, and the file isn't included in the index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip messages to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
         */
        var messageFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs that are required to connect to your Quip. The secret must contain a JSON structure with the following keys:
         * + accessToken—The token created in Quip. For more information, see [Authentication for a Quip data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#quip-authentication).
         */
        var secretArn: kotlin.String? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Quip threads to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Quip fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Quip field names must exist in your Quip custom metadata.
         */
        var threadFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Configuration information for an Amazon Virtual Private Cloud (VPC) to connect to your Quip. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QuipConfiguration) : this() {
            this.attachmentFieldMappings = x.attachmentFieldMappings
            this.crawlAttachments = x.crawlAttachments
            this.crawlChatRooms = x.crawlChatRooms
            this.crawlFileComments = x.crawlFileComments
            this.domain = x.domain
            this.exclusionPatterns = x.exclusionPatterns
            this.folderIds = x.folderIds
            this.inclusionPatterns = x.inclusionPatterns
            this.messageFieldMappings = x.messageFieldMappings
            this.secretArn = x.secretArn
            this.threadFieldMappings = x.threadFieldMappings
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QuipConfiguration = QuipConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
