// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * The configuration information for syncing a Salesforce chatter feed. The contents of the object comes from the Salesforce FeedItem table.
 */
class SalesforceChatterFeedConfiguration private constructor(builder: Builder) {
    /**
     * The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is the `Body` column.
     */
    val documentDataFieldName: kotlin.String? = builder.documentDataFieldName
    /**
     * The name of the column in the Salesforce FeedItem table that contains the title of the document. This is typically the `Title` column.
     */
    val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * Filters the documents in the feed based on status of the user. When you specify `ACTIVE_USERS` only documents from users who have an active account are indexed. When you specify `STANDARD_USER` only documents for Salesforce standard users are documented. You can specify both.
     */
    val includeFilterTypes: List<SalesforceChatterFeedIncludeFilterType>? = builder.includeFilterTypes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceChatterFeedConfiguration(")
        append("documentDataFieldName=$documentDataFieldName,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("fieldMappings=$fieldMappings,")
        append("includeFilterTypes=$includeFilterTypes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentDataFieldName?.hashCode() ?: 0
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (includeFilterTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceChatterFeedConfiguration

        if (documentDataFieldName != other.documentDataFieldName) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (fieldMappings != other.fieldMappings) return false
        if (includeFilterTypes != other.includeFilterTypes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the column in the Salesforce FeedItem table that contains the content to index. Typically this is the `Body` column.
         */
        var documentDataFieldName: kotlin.String? = null
        /**
         * The name of the column in the Salesforce FeedItem table that contains the title of the document. This is typically the `Title` column.
         */
        var documentTitleFieldName: kotlin.String? = null
        /**
         * Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Filters the documents in the feed based on status of the user. When you specify `ACTIVE_USERS` only documents from users who have an active account are indexed. When you specify `STANDARD_USER` only documents for Salesforce standard users are documented. You can specify both.
         */
        var includeFilterTypes: List<SalesforceChatterFeedIncludeFilterType>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration) : this() {
            this.documentDataFieldName = x.documentDataFieldName
            this.documentTitleFieldName = x.documentTitleFieldName
            this.fieldMappings = x.fieldMappings
            this.includeFilterTypes = x.includeFilterTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration = SalesforceChatterFeedConfiguration(this)
    }
}
