// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for indexing a single standard object.
 */
class SalesforceStandardObjectConfiguration private constructor(builder: Builder) {
    /**
     * The name of the field in the standard object table that contains the document contents.
     */
    val documentDataFieldName: kotlin.String? = builder.documentDataFieldName
    /**
     * The name of the field in the standard object table that contains the document title.
     */
    val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * Maps attributes or field names of the standard object to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * The name of the standard object.
     */
    val name: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectName? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceStandardObjectConfiguration(")
        append("documentDataFieldName=$documentDataFieldName,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("fieldMappings=$fieldMappings,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentDataFieldName?.hashCode() ?: 0
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceStandardObjectConfiguration

        if (documentDataFieldName != other.documentDataFieldName) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (fieldMappings != other.fieldMappings) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the field in the standard object table that contains the document contents.
         */
        var documentDataFieldName: kotlin.String? = null
        /**
         * The name of the field in the standard object table that contains the document title.
         */
        var documentTitleFieldName: kotlin.String? = null
        /**
         * Maps attributes or field names of the standard object to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The name of the standard object.
         */
        var name: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectName? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration) : this() {
            this.documentDataFieldName = x.documentDataFieldName
            this.documentTitleFieldName = x.documentTitleFieldName
            this.fieldMappings = x.fieldMappings
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectConfiguration = SalesforceStandardObjectConfiguration(this)
    }
}
