// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Specifies the document attribute to use to sort the response to a Amazon Kendra query. You can specify a single attribute for sorting. The attribute must have the `Sortable` flag set to `true`, otherwise Amazon Kendra returns an exception.
 *
 * You can sort attributes of the following types.
 * + Date value
 * + Long value
 * + String value
 *
 * You can't sort attributes of the following type.
 * + String list value
 */
class SortingConfiguration private constructor(builder: Builder) {
    /**
     * The name of the document attribute used to sort the response. You can use any field that has the `Sortable` flag set to true.
     *
     * You can also sort by any of the following built-in attributes:
     * + _category
     * + _created_at
     * + _last_updated_at
     * + _version
     * + _view_count
     */
    val documentAttributeKey: kotlin.String? = builder.documentAttributeKey
    /**
     * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.
     */
    val sortOrder: aws.sdk.kotlin.services.kendra.model.SortOrder? = builder.sortOrder

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SortingConfiguration(")
        append("documentAttributeKey=$documentAttributeKey,")
        append("sortOrder=$sortOrder)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentAttributeKey?.hashCode() ?: 0
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SortingConfiguration

        if (documentAttributeKey != other.documentAttributeKey) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the document attribute used to sort the response. You can use any field that has the `Sortable` flag set to true.
         *
         * You can also sort by any of the following built-in attributes:
         * + _category
         * + _created_at
         * + _last_updated_at
         * + _version
         * + _view_count
         */
        var documentAttributeKey: kotlin.String? = null
        /**
         * The order that the results should be returned in. In case of ties, the relevance assigned to the result by Amazon Kendra is used as the tie-breaker.
         */
        var sortOrder: aws.sdk.kotlin.services.kendra.model.SortOrder? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SortingConfiguration) : this() {
            this.documentAttributeKey = x.documentAttributeKey
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SortingConfiguration = SortingConfiguration(this)
    }
}
