// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class UpdateQuerySuggestionsConfigRequest private constructor(builder: Builder) {
    /**
     * `TRUE` to include queries without user information (i.e. all queries, irrespective of the user), otherwise `FALSE` to only include queries with user information.
     *
     * If you pass user information to Amazon Kendra along with the queries, you can set this flag to `FALSE` and instruct Amazon Kendra to only consider queries with user information.
     *
     * If you set to `FALSE`, Amazon Kendra only considers queries searched at least `MinimumQueryCount` times across `MinimumNumberOfQueryingUsers` unique users for suggestions.
     *
     * If you set to `TRUE`, Amazon Kendra ignores all user information and learns from all queries.
     */
    val includeQueriesWithoutUserInformation: kotlin.Boolean? = builder.includeQueriesWithoutUserInformation
    /**
     * The identifier of the index you want to update query suggestions settings for.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
     *
     * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.
     *
     * How you tune this setting depends on your specific needs.
     */
    val minimumNumberOfQueryingUsers: kotlin.Int? = builder.minimumNumberOfQueryingUsers
    /**
     * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
     *
     * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.
     *
     * How you tune this setting depends on your specific needs.
     */
    val minimumQueryCount: kotlin.Int? = builder.minimumQueryCount
    /**
     * Set the mode to `ENABLED` or `LEARN_ONLY`.
     *
     * By default, Amazon Kendra enables query suggestions. `LEARN_ONLY` mode allows you to turn off query suggestions. You can to update this at any time.
     *
     * In `LEARN_ONLY` mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.
     */
    val mode: aws.sdk.kotlin.services.kendra.model.Mode? = builder.mode
    /**
     * How recent your queries are in your query log time window.
     *
     * The time window is the number of days from current day to past days.
     *
     * By default, Amazon Kendra sets this to 180.
     */
    val queryLogLookBackWindowInDays: kotlin.Int? = builder.queryLogLookBackWindowInDays

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateQuerySuggestionsConfigRequest(")
        append("includeQueriesWithoutUserInformation=$includeQueriesWithoutUserInformation,")
        append("indexId=$indexId,")
        append("minimumNumberOfQueryingUsers=$minimumNumberOfQueryingUsers,")
        append("minimumQueryCount=$minimumQueryCount,")
        append("mode=$mode,")
        append("queryLogLookBackWindowInDays=$queryLogLookBackWindowInDays)")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeQueriesWithoutUserInformation?.hashCode() ?: 0
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (minimumNumberOfQueryingUsers ?: 0)
        result = 31 * result + (minimumQueryCount ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (queryLogLookBackWindowInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateQuerySuggestionsConfigRequest

        if (includeQueriesWithoutUserInformation != other.includeQueriesWithoutUserInformation) return false
        if (indexId != other.indexId) return false
        if (minimumNumberOfQueryingUsers != other.minimumNumberOfQueryingUsers) return false
        if (minimumQueryCount != other.minimumQueryCount) return false
        if (mode != other.mode) return false
        if (queryLogLookBackWindowInDays != other.queryLogLookBackWindowInDays) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * `TRUE` to include queries without user information (i.e. all queries, irrespective of the user), otherwise `FALSE` to only include queries with user information.
         *
         * If you pass user information to Amazon Kendra along with the queries, you can set this flag to `FALSE` and instruct Amazon Kendra to only consider queries with user information.
         *
         * If you set to `FALSE`, Amazon Kendra only considers queries searched at least `MinimumQueryCount` times across `MinimumNumberOfQueryingUsers` unique users for suggestions.
         *
         * If you set to `TRUE`, Amazon Kendra ignores all user information and learns from all queries.
         */
        var includeQueriesWithoutUserInformation: kotlin.Boolean? = null
        /**
         * The identifier of the index you want to update query suggestions settings for.
         */
        var indexId: kotlin.String? = null
        /**
         * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
         *
         * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.
         *
         * How you tune this setting depends on your specific needs.
         */
        var minimumNumberOfQueryingUsers: kotlin.Int? = null
        /**
         * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
         *
         * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.
         *
         * How you tune this setting depends on your specific needs.
         */
        var minimumQueryCount: kotlin.Int? = null
        /**
         * Set the mode to `ENABLED` or `LEARN_ONLY`.
         *
         * By default, Amazon Kendra enables query suggestions. `LEARN_ONLY` mode allows you to turn off query suggestions. You can to update this at any time.
         *
         * In `LEARN_ONLY` mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.
         */
        var mode: aws.sdk.kotlin.services.kendra.model.Mode? = null
        /**
         * How recent your queries are in your query log time window.
         *
         * The time window is the number of days from current day to past days.
         *
         * By default, Amazon Kendra sets this to 180.
         */
        var queryLogLookBackWindowInDays: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest) : this() {
            this.includeQueriesWithoutUserInformation = x.includeQueriesWithoutUserInformation
            this.indexId = x.indexId
            this.minimumNumberOfQueryingUsers = x.minimumNumberOfQueryingUsers
            this.minimumQueryCount = x.minimumQueryCount
            this.mode = x.mode
            this.queryLogLookBackWindowInDays = x.queryLogLookBackWindowInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = UpdateQuerySuggestionsConfigRequest(this)
    }
}
