// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information of the URLs to crawl.
 *
 * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
 *
 * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.*
 */
class Urls private constructor(builder: Builder) {
    /**
     * Configuration of the seed or starting point URLs of the websites you want to crawl.
     *
     * You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
     *
     * You can list up to 100 seed URLs.
     */
    val seedUrlConfiguration: aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration? = builder.seedUrlConfiguration
    /**
     * Configuration of the sitemap URLs of the websites you want to crawl.
     *
     * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
     */
    val siteMapsConfiguration: aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration? = builder.siteMapsConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Urls = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Urls(")
        append("seedUrlConfiguration=$seedUrlConfiguration,")
        append("siteMapsConfiguration=$siteMapsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = seedUrlConfiguration?.hashCode() ?: 0
        result = 31 * result + (siteMapsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Urls

        if (seedUrlConfiguration != other.seedUrlConfiguration) return false
        if (siteMapsConfiguration != other.siteMapsConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Urls = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration of the seed or starting point URLs of the websites you want to crawl.
         *
         * You can choose to crawl only the website host names, or the website host names with subdomains, or the website host names with subdomains and other domains that the webpages link to.
         *
         * You can list up to 100 seed URLs.
         */
        var seedUrlConfiguration: aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration? = null
        /**
         * Configuration of the sitemap URLs of the websites you want to crawl.
         *
         * Only URLs belonging to the same website host names are crawled. You can list up to three sitemap URLs.
         */
        var siteMapsConfiguration: aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Urls) : this() {
            this.seedUrlConfiguration = x.seedUrlConfiguration
            this.siteMapsConfiguration = x.siteMapsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Urls = Urls(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration] inside the given [block]
         */
        fun seedUrlConfiguration(block: aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration.Builder.() -> kotlin.Unit) {
            this.seedUrlConfiguration = aws.sdk.kotlin.services.kendra.model.SeedUrlConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration] inside the given [block]
         */
        fun siteMapsConfiguration(block: aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration.Builder.() -> kotlin.Unit) {
            this.siteMapsConfiguration = aws.sdk.kotlin.services.kendra.model.SiteMapsConfiguration.invoke(block)
        }
    }
}
