// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to fetch access levels of groups and users from an Amazon Web Services Single Sign On identity source. This is useful for setting up user context filtering, where Amazon Kendra filters search results for different users based on their group's access to documents. You can also map your users to their groups for user context filtering using the [PutPrincipalMapping API](https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html).
 *
 * To set up an Amazon Web Services SSO identity source in the console to use with Amazon Kendra, see [Getting started with an Amazon Web Services SSO identity source](https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html). You must also grant the required permissions to use Amazon Web Services SSO with Amazon Kendra. For more information, see [IAM roles for Amazon Web Services SSO](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso).
 *
 * Amazon Kendra currently does not support using `UserGroupResolutionConfiguration` with an Amazon Web Services organization member account for your Amazon Web Services SSO identify source. You must create your index in the management account for the organization in order to use `UserGroupResolutionConfiguration`.
 */
class UserGroupResolutionConfiguration private constructor(builder: Builder) {
    /**
     * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon Web Services SSO identity source in order to use this mode.
     */
    val userGroupResolutionMode: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionMode? = builder.userGroupResolutionMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserGroupResolutionConfiguration(")
        append("userGroupResolutionMode=$userGroupResolutionMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = userGroupResolutionMode?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserGroupResolutionConfiguration

        if (userGroupResolutionMode != other.userGroupResolutionMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identity store provider (mode) you want to use to fetch access levels of groups and users. Amazon Web Services Single Sign On is currently the only available mode. Your users and groups must exist in an Amazon Web Services SSO identity source in order to use this mode.
         */
        var userGroupResolutionMode: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration) : this() {
            this.userGroupResolutionMode = x.userGroupResolutionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = UserGroupResolutionConfiguration(this)
    }
}
