// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information required for Amazon Kendra Web Crawler.
 */
class WebCrawlerConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information required to connect to websites using authentication.
     *
     * You can connect to websites using basic authentication of user name and password.
     *
     * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) to store your authentication credentials.
     */
    val authenticationConfiguration: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration? = builder.authenticationConfiguration
    /**
     * Specifies the number of levels in a website that you want to crawl.
     *
     * The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.
     *
     * The default crawl depth is set to 2.
     */
    val crawlDepth: kotlin.Int? = builder.crawlDepth
    /**
     * The maximum size (in MB) of a webpage or attachment to crawl.
     *
     * Files larger than this size (in MB) are skipped/not crawled.
     *
     * The default maximum size of a webpage or attachment is set to 50 MB.
     */
    val maxContentSizePerPageInMegaBytes: kotlin.Float? = builder.maxContentSizePerPageInMegaBytes
    /**
     * The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.
     *
     * As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.
     *
     * The default maximum links per page is 100.
     */
    val maxLinksPerPage: kotlin.Int? = builder.maxLinksPerPage
    /**
     * The maximum number of URLs crawled per website host per minute.
     *
     * A minimum of one URL is required.
     *
     * The default maximum number of URLs crawled per website host per minute is 300.
     */
    val maxUrlsPerMinuteCrawlRate: kotlin.Int? = builder.maxUrlsPerMinuteCrawlRate
    /**
     * Configuration information required to connect to your internal websites via a web proxy.
     *
     * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
     *
     * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
     */
    val proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = builder.proxyConfiguration
    /**
     * A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
     */
    val urlExclusionPatterns: List<String>? = builder.urlExclusionPatterns
    /**
     * A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
     */
    val urlInclusionPatterns: List<String>? = builder.urlInclusionPatterns
    /**
     * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
     *
     * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
     *
     * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
     *
     * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.*
     */
    val urls: aws.sdk.kotlin.services.kendra.model.Urls? = builder.urls

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WebCrawlerConfiguration(")
        append("authenticationConfiguration=$authenticationConfiguration,")
        append("crawlDepth=$crawlDepth,")
        append("maxContentSizePerPageInMegaBytes=$maxContentSizePerPageInMegaBytes,")
        append("maxLinksPerPage=$maxLinksPerPage,")
        append("maxUrlsPerMinuteCrawlRate=$maxUrlsPerMinuteCrawlRate,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("urlExclusionPatterns=$urlExclusionPatterns,")
        append("urlInclusionPatterns=$urlInclusionPatterns,")
        append("urls=$urls)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationConfiguration?.hashCode() ?: 0
        result = 31 * result + (crawlDepth ?: 0)
        result = 31 * result + (maxContentSizePerPageInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (maxLinksPerPage ?: 0)
        result = 31 * result + (maxUrlsPerMinuteCrawlRate ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (urlExclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (urlInclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (urls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WebCrawlerConfiguration

        if (authenticationConfiguration != other.authenticationConfiguration) return false
        if (crawlDepth != other.crawlDepth) return false
        if (maxContentSizePerPageInMegaBytes != other.maxContentSizePerPageInMegaBytes) return false
        if (maxLinksPerPage != other.maxLinksPerPage) return false
        if (maxUrlsPerMinuteCrawlRate != other.maxUrlsPerMinuteCrawlRate) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (urlExclusionPatterns != other.urlExclusionPatterns) return false
        if (urlInclusionPatterns != other.urlInclusionPatterns) return false
        if (urls != other.urls) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration information required to connect to websites using authentication.
         *
         * You can connect to websites using basic authentication of user name and password.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS. You use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) to store your authentication credentials.
         */
        var authenticationConfiguration: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration? = null
        /**
         * Specifies the number of levels in a website that you want to crawl.
         *
         * The first level begins from the website seed or starting point URL. For example, if a website has 3 levels – index level (i.e. seed in this example), sections level, and subsections level – and you are only interested in crawling information up to the sections level (i.e. levels 0-1), you can set your depth to 1.
         *
         * The default crawl depth is set to 2.
         */
        var crawlDepth: kotlin.Int? = null
        /**
         * The maximum size (in MB) of a webpage or attachment to crawl.
         *
         * Files larger than this size (in MB) are skipped/not crawled.
         *
         * The default maximum size of a webpage or attachment is set to 50 MB.
         */
        var maxContentSizePerPageInMegaBytes: kotlin.Float? = null
        /**
         * The maximum number of URLs on a webpage to include when crawling a website. This number is per webpage.
         *
         * As a website’s webpages are crawled, any URLs the webpages link to are also crawled. URLs on a webpage are crawled in order of appearance.
         *
         * The default maximum links per page is 100.
         */
        var maxLinksPerPage: kotlin.Int? = null
        /**
         * The maximum number of URLs crawled per website host per minute.
         *
         * A minimum of one URL is required.
         *
         * The default maximum number of URLs crawled per website host per minute is 300.
         */
        var maxUrlsPerMinuteCrawlRate: kotlin.Int? = null
        /**
         * Configuration information required to connect to your internal websites via a web proxy.
         *
         * You must provide the website host name and port number. For example, the host name of https://a.example.com/page1.html is "a.example.com" and the port is 443, the standard port for HTTPS.
         *
         * Web proxy credentials are optional and you can use them to connect to a web proxy server that requires basic authentication. To store web proxy credentials, you use a secret in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
         */
        var proxyConfiguration: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration? = null
        /**
         * A list of regular expression patterns to exclude certain URLs to crawl. URLs that match the patterns are excluded from the index. URLs that don't match the patterns are included in the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        var urlExclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain URLs to crawl. URLs that match the patterns are included in the index. URLs that don't match the patterns are excluded from the index. If a URL matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the URL file isn't included in the index.
         */
        var urlInclusionPatterns: List<String>? = null
        /**
         * Specifies the seed or starting point URLs of the websites or the sitemap URLs of the websites you want to crawl.
         *
         * You can include website subdomains. You can list up to 100 seed URLs and up to three sitemap URLs.
         *
         * You can only crawl websites that use the secure communication protocol, Hypertext Transfer Protocol Secure (HTTPS). If you receive an error when crawling a website, it could be that the website is blocked from crawling.
         *
         * *When selecting websites to index, you must adhere to the [Amazon Acceptable Use Policy](https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to index your own webpages, or webpages that you have authorization to index.*
         */
        var urls: aws.sdk.kotlin.services.kendra.model.Urls? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration) : this() {
            this.authenticationConfiguration = x.authenticationConfiguration
            this.crawlDepth = x.crawlDepth
            this.maxContentSizePerPageInMegaBytes = x.maxContentSizePerPageInMegaBytes
            this.maxLinksPerPage = x.maxLinksPerPage
            this.maxUrlsPerMinuteCrawlRate = x.maxUrlsPerMinuteCrawlRate
            this.proxyConfiguration = x.proxyConfiguration
            this.urlExclusionPatterns = x.urlExclusionPatterns
            this.urlInclusionPatterns = x.urlInclusionPatterns
            this.urls = x.urls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.WebCrawlerConfiguration = WebCrawlerConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration] inside the given [block]
         */
        fun authenticationConfiguration(block: aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration.Builder.() -> kotlin.Unit) {
            this.authenticationConfiguration = aws.sdk.kotlin.services.kendra.model.AuthenticationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ProxyConfiguration] inside the given [block]
         */
        fun proxyConfiguration(block: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.kendra.model.ProxyConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.Urls] inside the given [block]
         */
        fun urls(block: aws.sdk.kotlin.services.kendra.model.Urls.Builder.() -> kotlin.Unit) {
            this.urls = aws.sdk.kotlin.services.kendra.model.Urls.invoke(block)
        }
    }
}
