// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kendra.model.DescribePrincipalMappingResponse
import aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribePrincipalMappingOperationDeserializer: HttpDeserialize<DescribePrincipalMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePrincipalMappingResponse {
        if (!response.status.isSuccess()) {
            throwDescribePrincipalMappingError(context, response)
        }
        val builder = DescribePrincipalMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePrincipalMappingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePrincipalMappingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePrincipalMappingOperationBody(builder: DescribePrincipalMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DataSourceId"))
    val GROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupId"))
    val GROUPORDERINGIDSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GroupOrderingIdSummaries"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCEID_DESCRIPTOR)
        field(GROUPID_DESCRIPTOR)
        field(GROUPORDERINGIDSUMMARIES_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATASOURCEID_DESCRIPTOR.index -> builder.dataSourceId = deserializeString()
                GROUPID_DESCRIPTOR.index -> builder.groupId = deserializeString()
                GROUPORDERINGIDSUMMARIES_DESCRIPTOR.index -> builder.groupOrderingIdSummaries =
                    deserializer.deserializeList(GROUPORDERINGIDSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupOrderingIdSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupOrderingIdSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
