// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.kendra.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kendra.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon Kendra is a service for indexing large document sets.
 */
interface KendraClient : SdkClient {

    override val serviceName: String
        get() = "kendra"
    /**
     * KendraClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): KendraClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultKendraClient(config)
        }

        operator fun invoke(config: Config): KendraClient = DefaultKendraClient(config)

        /**
         * Construct a [KendraClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): KendraClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return KendraClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Grants users or groups in your Amazon Web Services SSO identity source access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a
     * search application. For more information on creating a search application
     * experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun associateEntitiesToExperience(input: AssociateEntitiesToExperienceRequest): AssociateEntitiesToExperienceResponse

    /**
     * Grants users or groups in your Amazon Web Services SSO identity source access
     * to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a
     * search application. For more information on creating a search application
     * experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun associateEntitiesToExperience(block: AssociateEntitiesToExperienceRequest.Builder.() -> Unit) = associateEntitiesToExperience(AssociateEntitiesToExperienceRequest.Builder().apply(block).build())

    /**
     * Defines the specific permissions of users or groups in your Amazon Web Services SSO
     * identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra
     * experience such as a search application. For more information on creating a
     * search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun associatePersonasToEntities(input: AssociatePersonasToEntitiesRequest): AssociatePersonasToEntitiesResponse

    /**
     * Defines the specific permissions of users or groups in your Amazon Web Services SSO
     * identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra
     * experience such as a search application. For more information on creating a
     * search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun associatePersonasToEntities(block: AssociatePersonasToEntitiesRequest.Builder.() -> Unit) = associatePersonasToEntities(AssociatePersonasToEntitiesRequest.Builder().apply(block).build())

    /**
     * Removes one or more documents from an index. The documents must have
     * been added with the BatchPutDocument operation.
     * The documents are deleted asynchronously. You can see the progress of
     * the deletion by using Amazon Web Services CloudWatch. Any error messages related to the
     * processing of the batch are sent to you CloudWatch log.
     */
    suspend fun batchDeleteDocument(input: BatchDeleteDocumentRequest): BatchDeleteDocumentResponse

    /**
     * Removes one or more documents from an index. The documents must have
     * been added with the BatchPutDocument operation.
     * The documents are deleted asynchronously. You can see the progress of
     * the deletion by using Amazon Web Services CloudWatch. Any error messages related to the
     * processing of the batch are sent to you CloudWatch log.
     */
    suspend fun batchDeleteDocument(block: BatchDeleteDocumentRequest.Builder.() -> Unit) = batchDeleteDocument(BatchDeleteDocumentRequest.Builder().apply(block).build())

    /**
     * Returns the indexing status for one or more documents submitted
     * with the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">
     * BatchPutDocument operation.
     * When you use the BatchPutDocument operation,
     * documents are indexed asynchronously. You can use the
     * BatchGetDocumentStatus operation to get the current
     * status of a list of documents so that you can determine if they have
     * been successfully indexed.
     * You can also use the BatchGetDocumentStatus operation
     * to check the status of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html">
     * BatchDeleteDocument operation. When a document is
     * deleted from the index, Amazon Kendra returns NOT_FOUND as the
     * status.
     */
    suspend fun batchGetDocumentStatus(input: BatchGetDocumentStatusRequest): BatchGetDocumentStatusResponse

    /**
     * Returns the indexing status for one or more documents submitted
     * with the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">
     * BatchPutDocument operation.
     * When you use the BatchPutDocument operation,
     * documents are indexed asynchronously. You can use the
     * BatchGetDocumentStatus operation to get the current
     * status of a list of documents so that you can determine if they have
     * been successfully indexed.
     * You can also use the BatchGetDocumentStatus operation
     * to check the status of the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html">
     * BatchDeleteDocument operation. When a document is
     * deleted from the index, Amazon Kendra returns NOT_FOUND as the
     * status.
     */
    suspend fun batchGetDocumentStatus(block: BatchGetDocumentStatusRequest.Builder.() -> Unit) = batchGetDocumentStatus(BatchGetDocumentStatusRequest.Builder().apply(block).build())

    /**
     * Adds one or more documents to an index.
     * The BatchPutDocument operation enables you to ingest
     * inline documents or a set of documents stored in an Amazon S3 bucket. Use
     * this operation to ingest your text and unstructured text into an index,
     * add custom attributes to the documents, and to attach an access control
     * list to the documents added to the index.
     * The documents are indexed asynchronously. You can see the progress of
     * the batch using Amazon Web Services CloudWatch. Any error messages related to processing
     * the batch are sent to your Amazon Web Services CloudWatch log.
     */
    suspend fun batchPutDocument(input: BatchPutDocumentRequest): BatchPutDocumentResponse

    /**
     * Adds one or more documents to an index.
     * The BatchPutDocument operation enables you to ingest
     * inline documents or a set of documents stored in an Amazon S3 bucket. Use
     * this operation to ingest your text and unstructured text into an index,
     * add custom attributes to the documents, and to attach an access control
     * list to the documents added to the index.
     * The documents are indexed asynchronously. You can see the progress of
     * the batch using Amazon Web Services CloudWatch. Any error messages related to processing
     * the batch are sent to your Amazon Web Services CloudWatch log.
     */
    suspend fun batchPutDocument(block: BatchPutDocumentRequest.Builder.() -> Unit) = batchPutDocument(BatchPutDocumentRequest.Builder().apply(block).build())

    /**
     * Clears existing query suggestions from an index.
     * This deletes existing suggestions only, not the queries
     * in the query log. After you clear suggestions, Amazon Kendra learns
     * new suggestions based on new queries added to the query log
     * from the time you cleared suggestions. If you do not see any
     * new suggestions, then please allow Amazon Kendra to collect
     * enough queries to learn new suggestions.
     * ClearQuerySuggestions is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun clearQuerySuggestions(input: ClearQuerySuggestionsRequest): ClearQuerySuggestionsResponse

    /**
     * Clears existing query suggestions from an index.
     * This deletes existing suggestions only, not the queries
     * in the query log. After you clear suggestions, Amazon Kendra learns
     * new suggestions based on new queries added to the query log
     * from the time you cleared suggestions. If you do not see any
     * new suggestions, then please allow Amazon Kendra to collect
     * enough queries to learn new suggestions.
     * ClearQuerySuggestions is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun clearQuerySuggestions(block: ClearQuerySuggestionsRequest.Builder.() -> Unit) = clearQuerySuggestions(ClearQuerySuggestionsRequest.Builder().apply(block).build())

    /**
     * Creates a data source that you want to use with an Amazon Kendra index.
     * You specify a name, data source connector type and description for
     * your data source. You also specify configuration information for the
     * data source connector.
     * CreateDataSource is a synchronous operation. The
     * operation returns 200 if the data source was successfully created.
     * Otherwise, an exception is raised.
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom data sources are
     * the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates a data source that you want to use with an Amazon Kendra index.
     * You specify a name, data source connector type and description for
     * your data source. You also specify configuration information for the
     * data source connector.
     * CreateDataSource is a synchronous operation. The
     * operation returns 200 if the data source was successfully created.
     * Otherwise, an exception is raised.
     * Amazon S3 and <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-custom.html">custom data sources are
     * the only supported data sources in the Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun createDataSource(block: CreateDataSourceRequest.Builder.() -> Unit) = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun createExperience(input: CreateExperienceRequest): CreateExperienceResponse

    /**
     * Creates an Amazon Kendra experience such as a search application. For more information
     * on creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun createExperience(block: CreateExperienceRequest.Builder.() -> Unit) = createExperience(CreateExperienceRequest.Builder().apply(block).build())

    /**
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * Adding FAQs to an index is an asynchronous operation.
     */
    suspend fun createFaq(input: CreateFaqRequest): CreateFaqResponse

    /**
     * Creates an new set of frequently asked question (FAQ) questions and answers.
     * Adding FAQs to an index is an asynchronous operation.
     */
    suspend fun createFaq(block: CreateFaqRequest.Builder.() -> Unit) = createFaq(CreateFaqRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Kendra index. Index creation is an asynchronous
     * operation. To determine if index creation has completed, check the
     * Status field returned from a call to
     * DescribeIndex. The Status field is set to
     * ACTIVE when the index is ready to use.
     * Once the index is active you can index your documents using the
     * BatchPutDocument operation or using one of the supported
     * data sources.
     */
    suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Creates a new Amazon Kendra index. Index creation is an asynchronous
     * operation. To determine if index creation has completed, check the
     * Status field returned from a call to
     * DescribeIndex. The Status field is set to
     * ACTIVE when the index is ready to use.
     * Once the index is active you can index your documents using the
     * BatchPutDocument operation or using one of the supported
     * data sources.
     */
    suspend fun createIndex(block: CreateIndexRequest.Builder.() -> Unit) = createIndex(CreateIndexRequest.Builder().apply(block).build())

    /**
     * Creates a block list to exlcude certain queries from suggestions.
     * Any query that contains words or phrases specified in the block
     * list is blocked or filtered out from being shown as a suggestion.
     * You need to provide the file location of your block list text file
     * in your S3 bucket. In your text file, enter each block word or phrase
     * on a separate line.
     * For information on the current quota limits for block lists, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
     * for Amazon Kendra.
     * CreateQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun createQuerySuggestionsBlockList(input: CreateQuerySuggestionsBlockListRequest): CreateQuerySuggestionsBlockListResponse

    /**
     * Creates a block list to exlcude certain queries from suggestions.
     * Any query that contains words or phrases specified in the block
     * list is blocked or filtered out from being shown as a suggestion.
     * You need to provide the file location of your block list text file
     * in your S3 bucket. In your text file, enter each block word or phrase
     * on a separate line.
     * For information on the current quota limits for block lists, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
     * for Amazon Kendra.
     * CreateQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun createQuerySuggestionsBlockList(block: CreateQuerySuggestionsBlockListRequest.Builder.() -> Unit) = createQuerySuggestionsBlockList(CreateQuerySuggestionsBlockListRequest.Builder().apply(block).build())

    /**
     * Creates a thesaurus for an index. The thesaurus
     * contains a list of synonyms in Solr format.
     */
    suspend fun createThesaurus(input: CreateThesaurusRequest): CreateThesaurusResponse

    /**
     * Creates a thesaurus for an index. The thesaurus
     * contains a list of synonyms in Solr format.
     */
    suspend fun createThesaurus(block: CreateThesaurusRequest.Builder.() -> Unit) = createThesaurus(CreateThesaurusRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon Kendra data source. An exception is not thrown if the
     * data source is already being deleted. While the data source is being
     * deleted, the Status field returned by a call to the
     * DescribeDataSource operation is set to
     * DELETING. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources.
     */
    suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes an Amazon Kendra data source. An exception is not thrown if the
     * data source is already being deleted. While the data source is being
     * deleted, the Status field returned by a call to the
     * DescribeDataSource operation is set to
     * DELETING. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html">Deleting Data Sources.
     */
    suspend fun deleteDataSource(block: DeleteDataSourceRequest.Builder.() -> Unit) = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

    /**
     * Deletes your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code.
     */
    suspend fun deleteExperience(input: DeleteExperienceRequest): DeleteExperienceResponse

    /**
     * Deletes your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a search
     * experience with no code.
     */
    suspend fun deleteExperience(block: DeleteExperienceRequest.Builder.() -> Unit) = deleteExperience(DeleteExperienceRequest.Builder().apply(block).build())

    /**
     * Removes an FAQ from an index.
     */
    suspend fun deleteFaq(input: DeleteFaqRequest): DeleteFaqResponse

    /**
     * Removes an FAQ from an index.
     */
    suspend fun deleteFaq(block: DeleteFaqRequest.Builder.() -> Unit) = deleteFaq(DeleteFaqRequest.Builder().apply(block).build())

    /**
     * Deletes an existing Amazon Kendra index. An exception is not thrown if
     * the index is already being deleted. While the index is being deleted, the
     * Status field returned by a call to the
     * DescribeIndex operation is set to
     * DELETING.
     */
    suspend fun deleteIndex(input: DeleteIndexRequest): DeleteIndexResponse

    /**
     * Deletes an existing Amazon Kendra index. An exception is not thrown if
     * the index is already being deleted. While the index is being deleted, the
     * Status field returned by a call to the
     * DescribeIndex operation is set to
     * DELETING.
     */
    suspend fun deleteIndex(block: DeleteIndexRequest.Builder.() -> Unit) = deleteIndex(DeleteIndexRequest.Builder().apply(block).build())

    /**
     * Deletes a group so that all users and sub groups that belong to the group can
     * no longer access documents only available to that group.
     * For example, after deleting the group "Summer Interns", all interns who
     * belonged to that group no longer see intern-only documents in their search
     * results.
     * If you want to delete or replace users or sub groups of a group, you need to
     * use the PutPrincipalMapping operation. For example, if a user in
     * the group "Engineering" leaves the engineering team and another user takes
     * their place, you provide an updated list of users or sub groups that belong
     * to the "Engineering" group when calling PutPrincipalMapping. You
     * can update your internal list of users or sub groups and input this list
     * when calling PutPrincipalMapping.
     * DeletePrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun deletePrincipalMapping(input: DeletePrincipalMappingRequest): DeletePrincipalMappingResponse

    /**
     * Deletes a group so that all users and sub groups that belong to the group can
     * no longer access documents only available to that group.
     * For example, after deleting the group "Summer Interns", all interns who
     * belonged to that group no longer see intern-only documents in their search
     * results.
     * If you want to delete or replace users or sub groups of a group, you need to
     * use the PutPrincipalMapping operation. For example, if a user in
     * the group "Engineering" leaves the engineering team and another user takes
     * their place, you provide an updated list of users or sub groups that belong
     * to the "Engineering" group when calling PutPrincipalMapping. You
     * can update your internal list of users or sub groups and input this list
     * when calling PutPrincipalMapping.
     * DeletePrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun deletePrincipalMapping(block: DeletePrincipalMappingRequest.Builder.() -> Unit) = deletePrincipalMapping(DeletePrincipalMappingRequest.Builder().apply(block).build())

    /**
     * Deletes a block list used for query suggestions for an index.
     * A deleted block list might not take effect right away. Amazon Kendra
     * needs to refresh the entire suggestions list to add back the
     * queries that were previously blocked.
     * DeleteQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun deleteQuerySuggestionsBlockList(input: DeleteQuerySuggestionsBlockListRequest): DeleteQuerySuggestionsBlockListResponse

    /**
     * Deletes a block list used for query suggestions for an index.
     * A deleted block list might not take effect right away. Amazon Kendra
     * needs to refresh the entire suggestions list to add back the
     * queries that were previously blocked.
     * DeleteQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun deleteQuerySuggestionsBlockList(block: DeleteQuerySuggestionsBlockListRequest.Builder.() -> Unit) = deleteQuerySuggestionsBlockList(DeleteQuerySuggestionsBlockListRequest.Builder().apply(block).build())

    /**
     * Deletes an existing Amazon Kendra thesaurus.
     */
    suspend fun deleteThesaurus(input: DeleteThesaurusRequest): DeleteThesaurusResponse

    /**
     * Deletes an existing Amazon Kendra thesaurus.
     */
    suspend fun deleteThesaurus(block: DeleteThesaurusRequest.Builder.() -> Unit) = deleteThesaurus(DeleteThesaurusRequest.Builder().apply(block).build())

    /**
     * Gets information about a Amazon Kendra data source.
     */
    suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse

    /**
     * Gets information about a Amazon Kendra data source.
     */
    suspend fun describeDataSource(block: DescribeDataSourceRequest.Builder.() -> Unit) = describeDataSource(DescribeDataSourceRequest.Builder().apply(block).build())

    /**
     * Gets information about your Amazon Kendra experience such as a search application.
     * For more information on creating a search application experience,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun describeExperience(input: DescribeExperienceRequest): DescribeExperienceResponse

    /**
     * Gets information about your Amazon Kendra experience such as a search application.
     * For more information on creating a search application experience,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun describeExperience(block: DescribeExperienceRequest.Builder.() -> Unit) = describeExperience(DescribeExperienceRequest.Builder().apply(block).build())

    /**
     * Gets information about an FAQ list.
     */
    suspend fun describeFaq(input: DescribeFaqRequest): DescribeFaqResponse

    /**
     * Gets information about an FAQ list.
     */
    suspend fun describeFaq(block: DescribeFaqRequest.Builder.() -> Unit) = describeFaq(DescribeFaqRequest.Builder().apply(block).build())

    /**
     * Describes an existing Amazon Kendra index
     */
    suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse

    /**
     * Describes an existing Amazon Kendra index
     */
    suspend fun describeIndex(block: DescribeIndexRequest.Builder.() -> Unit) = describeIndex(DescribeIndexRequest.Builder().apply(block).build())

    /**
     * Describes the processing of PUT and DELETE actions
     * for mapping users to their groups. This includes information on the status of
     * actions currently processing or yet to be processed, when actions were last updated,
     * when actions were received by Amazon Kendra, the latest action that should process
     * and apply after other actions, and useful error messages if an action could
     * not be processed.
     * DescribePrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describePrincipalMapping(input: DescribePrincipalMappingRequest): DescribePrincipalMappingResponse

    /**
     * Describes the processing of PUT and DELETE actions
     * for mapping users to their groups. This includes information on the status of
     * actions currently processing or yet to be processed, when actions were last updated,
     * when actions were received by Amazon Kendra, the latest action that should process
     * and apply after other actions, and useful error messages if an action could
     * not be processed.
     * DescribePrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describePrincipalMapping(block: DescribePrincipalMappingRequest.Builder.() -> Unit) = describePrincipalMapping(DescribePrincipalMappingRequest.Builder().apply(block).build())

    /**
     * Describes a block list used for query suggestions for an index.
     * This is used to check the current settings that are applied to a
     * block list.
     * DescribeQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describeQuerySuggestionsBlockList(input: DescribeQuerySuggestionsBlockListRequest): DescribeQuerySuggestionsBlockListResponse

    /**
     * Describes a block list used for query suggestions for an index.
     * This is used to check the current settings that are applied to a
     * block list.
     * DescribeQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describeQuerySuggestionsBlockList(block: DescribeQuerySuggestionsBlockListRequest.Builder.() -> Unit) = describeQuerySuggestionsBlockList(DescribeQuerySuggestionsBlockListRequest.Builder().apply(block).build())

    /**
     * Describes the settings of query suggestions for an index.
     * This is used to check the current settings applied
     * to query suggestions.
     * DescribeQuerySuggestionsConfig is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describeQuerySuggestionsConfig(input: DescribeQuerySuggestionsConfigRequest): DescribeQuerySuggestionsConfigResponse

    /**
     * Describes the settings of query suggestions for an index.
     * This is used to check the current settings applied
     * to query suggestions.
     * DescribeQuerySuggestionsConfig is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun describeQuerySuggestionsConfig(block: DescribeQuerySuggestionsConfigRequest.Builder.() -> Unit) = describeQuerySuggestionsConfig(DescribeQuerySuggestionsConfigRequest.Builder().apply(block).build())

    /**
     * Describes an existing Amazon Kendra thesaurus.
     */
    suspend fun describeThesaurus(input: DescribeThesaurusRequest): DescribeThesaurusResponse

    /**
     * Describes an existing Amazon Kendra thesaurus.
     */
    suspend fun describeThesaurus(block: DescribeThesaurusRequest.Builder.() -> Unit) = describeThesaurus(DescribeThesaurusRequest.Builder().apply(block).build())

    /**
     * Prevents users or groups in your Amazon Web Services SSO identity source
     * from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience
     * such as a search application. For more information on creating a search
     * application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun disassociateEntitiesFromExperience(input: DisassociateEntitiesFromExperienceRequest): DisassociateEntitiesFromExperienceResponse

    /**
     * Prevents users or groups in your Amazon Web Services SSO identity source
     * from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience
     * such as a search application. For more information on creating a search
     * application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun disassociateEntitiesFromExperience(block: DisassociateEntitiesFromExperienceRequest.Builder.() -> Unit) = disassociateEntitiesFromExperience(DisassociateEntitiesFromExperienceRequest.Builder().apply(block).build())

    /**
     * Removes the specific permissions of users or groups in your Amazon Web Services SSO
     * identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra
     * experience such as a search application. For more information on creating a
     * search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun disassociatePersonasFromEntities(input: DisassociatePersonasFromEntitiesRequest): DisassociatePersonasFromEntitiesResponse

    /**
     * Removes the specific permissions of users or groups in your Amazon Web Services SSO
     * identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra
     * experience such as a search application. For more information on creating a
     * search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun disassociatePersonasFromEntities(block: DisassociatePersonasFromEntitiesRequest.Builder.() -> Unit) = disassociatePersonasFromEntities(DisassociatePersonasFromEntitiesRequest.Builder().apply(block).build())

    /**
     * Fetches the queries that are suggested to your users.
     * GetQuerySuggestions is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun getQuerySuggestions(input: GetQuerySuggestionsRequest): GetQuerySuggestionsResponse

    /**
     * Fetches the queries that are suggested to your users.
     * GetQuerySuggestions is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun getQuerySuggestions(block: GetQuerySuggestionsRequest.Builder.() -> Unit) = getQuerySuggestions(GetQuerySuggestionsRequest.Builder().apply(block).build())

    /**
     * Retrieves search metrics data. The data provides a snapshot of how
     * your users interact with your search application and how effective
     * the application is.
     */
    suspend fun getSnapshots(input: GetSnapshotsRequest): GetSnapshotsResponse

    /**
     * Retrieves search metrics data. The data provides a snapshot of how
     * your users interact with your search application and how effective
     * the application is.
     */
    suspend fun getSnapshots(block: GetSnapshotsRequest.Builder.() -> Unit) = getSnapshots(GetSnapshotsRequest.Builder().apply(block).build())

    /**
     * Gets statistics about synchronizing Amazon Kendra with a data
     * source.
     */
    suspend fun listDataSourceSyncJobs(input: ListDataSourceSyncJobsRequest): ListDataSourceSyncJobsResponse

    /**
     * Gets statistics about synchronizing Amazon Kendra with a data
     * source.
     */
    suspend fun listDataSourceSyncJobs(block: ListDataSourceSyncJobsRequest.Builder.() -> Unit) = listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.Builder().apply(block).build())

    /**
     * Lists the data sources that you have created.
     */
    suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists the data sources that you have created.
     */
    suspend fun listDataSources(block: ListDataSourcesRequest.Builder.() -> Unit) = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

    /**
     * Lists specific permissions of users and groups with access to your
     * Amazon Kendra experience.
     */
    suspend fun listEntityPersonas(input: ListEntityPersonasRequest): ListEntityPersonasResponse

    /**
     * Lists specific permissions of users and groups with access to your
     * Amazon Kendra experience.
     */
    suspend fun listEntityPersonas(block: ListEntityPersonasRequest.Builder.() -> Unit) = listEntityPersonas(ListEntityPersonasRequest.Builder().apply(block).build())

    /**
     * Lists users or groups in your Amazon Web Services SSO identity source that are
     * granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience
     * such as a search application. For more information on creating a search
     * application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun listExperienceEntities(input: ListExperienceEntitiesRequest): ListExperienceEntitiesResponse

    /**
     * Lists users or groups in your Amazon Web Services SSO identity source that are
     * granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience
     * such as a search application. For more information on creating a search
     * application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building
     * a search experience with no code.
     */
    suspend fun listExperienceEntities(block: ListExperienceEntitiesRequest.Builder.() -> Unit) = listExperienceEntities(ListExperienceEntitiesRequest.Builder().apply(block).build())

    /**
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such
     * as a search application. For more information on creating a search application
     * experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun listExperiences(input: ListExperiencesRequest): ListExperiencesResponse

    /**
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such
     * as a search application. For more information on creating a search application
     * experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun listExperiences(block: ListExperiencesRequest.Builder.() -> Unit) = listExperiences(ListExperiencesRequest.Builder().apply(block).build())

    /**
     * Gets a list of FAQ lists associated with an index.
     */
    suspend fun listFaqs(input: ListFaqsRequest): ListFaqsResponse

    /**
     * Gets a list of FAQ lists associated with an index.
     */
    suspend fun listFaqs(block: ListFaqsRequest.Builder.() -> Unit) = listFaqs(ListFaqsRequest.Builder().apply(block).build())

    /**
     * Provides a list of groups that are mapped to users before a
     * given ordering or timestamp identifier.
     * ListGroupsOlderThanOrderingId is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun listGroupsOlderThanOrderingId(input: ListGroupsOlderThanOrderingIdRequest): ListGroupsOlderThanOrderingIdResponse

    /**
     * Provides a list of groups that are mapped to users before a
     * given ordering or timestamp identifier.
     * ListGroupsOlderThanOrderingId is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun listGroupsOlderThanOrderingId(block: ListGroupsOlderThanOrderingIdRequest.Builder.() -> Unit) = listGroupsOlderThanOrderingId(ListGroupsOlderThanOrderingIdRequest.Builder().apply(block).build())

    /**
     * Lists the Amazon Kendra indexes that you have created.
     */
    suspend fun listIndices(input: ListIndicesRequest): ListIndicesResponse

    /**
     * Lists the Amazon Kendra indexes that you have created.
     */
    suspend fun listIndices(block: ListIndicesRequest.Builder.() -> Unit) = listIndices(ListIndicesRequest.Builder().apply(block).build())

    /**
     * Lists the block lists used for query suggestions for an index.
     * For information on the current quota limits for block lists, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
     * for Amazon Kendra.
     * ListQuerySuggestionsBlockLists is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun listQuerySuggestionsBlockLists(input: ListQuerySuggestionsBlockListsRequest): ListQuerySuggestionsBlockListsResponse

    /**
     * Lists the block lists used for query suggestions for an index.
     * For information on the current quota limits for block lists, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
     * for Amazon Kendra.
     * ListQuerySuggestionsBlockLists is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun listQuerySuggestionsBlockLists(block: ListQuerySuggestionsBlockListsRequest.Builder.() -> Unit) = listQuerySuggestionsBlockLists(ListQuerySuggestionsBlockListsRequest.Builder().apply(block).build())

    /**
     * Gets a list of tags associated with a specified resource. Indexes,
     * FAQs, and data sources can have tags associated with them.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of tags associated with a specified resource. Indexes,
     * FAQs, and data sources can have tags associated with them.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists the Amazon Kendra thesauri associated with an index.
     */
    suspend fun listThesauri(input: ListThesauriRequest): ListThesauriResponse

    /**
     * Lists the Amazon Kendra thesauri associated with an index.
     */
    suspend fun listThesauri(block: ListThesauriRequest.Builder.() -> Unit) = listThesauri(ListThesauriRequest.Builder().apply(block).build())

    /**
     * Maps users to their groups so that you only need to provide
     * the user ID when you issue the query.
     * You can also map sub groups to groups.
     * For example, the group "Company Intellectual Property Teams" includes
     * sub groups "Research" and "Engineering". These sub groups include their
     * own list of users or people who work in these teams. Only users who work
     * in research and engineering, and therefore belong in the intellectual
     * property group, can see top-secret company documents in their search
     * results.
     * You map users to their groups when you want to filter search results
     * for different users based on their group’s access to documents. For more
     * information on filtering search results for different users, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering
     * on user context.
     * If more than five PUT actions for a group are currently
     * processing, a validation exception is thrown.
     * PutPrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun putPrincipalMapping(input: PutPrincipalMappingRequest): PutPrincipalMappingResponse

    /**
     * Maps users to their groups so that you only need to provide
     * the user ID when you issue the query.
     * You can also map sub groups to groups.
     * For example, the group "Company Intellectual Property Teams" includes
     * sub groups "Research" and "Engineering". These sub groups include their
     * own list of users or people who work in these teams. Only users who work
     * in research and engineering, and therefore belong in the intellectual
     * property group, can see top-secret company documents in their search
     * results.
     * You map users to their groups when you want to filter search results
     * for different users based on their group’s access to documents. For more
     * information on filtering search results for different users, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html">Filtering
     * on user context.
     * If more than five PUT actions for a group are currently
     * processing, a validation exception is thrown.
     * PutPrincipalMapping is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun putPrincipalMapping(block: PutPrincipalMappingRequest.Builder.() -> Unit) = putPrincipalMapping(PutPrincipalMappingRequest.Builder().apply(block).build())

    /**
     * Searches an active index. Use this API to search your documents
     * using query. The Query operation enables to do faceted
     * search and to filter results based on document attributes.
     * It also enables you to provide user context that Amazon Kendra uses
     * to enforce document access control in the search results.
     * Amazon Kendra searches your index for text content and question and
     * answer (FAQ) content. By default the response contains three types of
     * results.
     * Relevant passages
     * Matching FAQs
     * Relevant documents
     * You can specify that the query return only one type of result using
     * the QueryResultTypeConfig parameter.
     * Each query returns the 100 most relevant results.
     */
    suspend fun query(input: QueryRequest): QueryResponse

    /**
     * Searches an active index. Use this API to search your documents
     * using query. The Query operation enables to do faceted
     * search and to filter results based on document attributes.
     * It also enables you to provide user context that Amazon Kendra uses
     * to enforce document access control in the search results.
     * Amazon Kendra searches your index for text content and question and
     * answer (FAQ) content. By default the response contains three types of
     * results.
     * Relevant passages
     * Matching FAQs
     * Relevant documents
     * You can specify that the query return only one type of result using
     * the QueryResultTypeConfig parameter.
     * Each query returns the 100 most relevant results.
     */
    suspend fun query(block: QueryRequest.Builder.() -> Unit) = query(QueryRequest.Builder().apply(block).build())

    /**
     * Starts a synchronization job for a data source. If a synchronization
     * job is already in progress, Amazon Kendra returns a
     * ResourceInUseException exception.
     */
    suspend fun startDataSourceSyncJob(input: StartDataSourceSyncJobRequest): StartDataSourceSyncJobResponse

    /**
     * Starts a synchronization job for a data source. If a synchronization
     * job is already in progress, Amazon Kendra returns a
     * ResourceInUseException exception.
     */
    suspend fun startDataSourceSyncJob(block: StartDataSourceSyncJobRequest.Builder.() -> Unit) = startDataSourceSyncJob(StartDataSourceSyncJobRequest.Builder().apply(block).build())

    /**
     * Stops a running synchronization job. You can't stop a scheduled
     * synchronization job.
     */
    suspend fun stopDataSourceSyncJob(input: StopDataSourceSyncJobRequest): StopDataSourceSyncJobResponse

    /**
     * Stops a running synchronization job. You can't stop a scheduled
     * synchronization job.
     */
    suspend fun stopDataSourceSyncJob(block: StopDataSourceSyncJobRequest.Builder.() -> Unit) = stopDataSourceSyncJob(StopDataSourceSyncJobRequest.Builder().apply(block).build())

    /**
     * Enables you to provide feedback to Amazon Kendra to improve the
     * performance of your index.
     * SubmitFeedback is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse

    /**
     * Enables you to provide feedback to Amazon Kendra to improve the
     * performance of your index.
     * SubmitFeedback is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun submitFeedback(block: SubmitFeedbackRequest.Builder.() -> Unit) = submitFeedback(SubmitFeedbackRequest.Builder().apply(block).build())

    /**
     * Adds the specified tag to the specified index, FAQ, or data source
     * resource. If the tag already exists, the existing value is replaced with
     * the new value.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tag to the specified index, FAQ, or data source
     * resource. If the tag already exists, the existing value is replaced with
     * the new value.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a tag from an index, FAQ, or a data source.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from an index, FAQ, or a data source.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an existing Amazon Kendra data source.
     */
    suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates an existing Amazon Kendra data source.
     */
    suspend fun updateDataSource(block: UpdateDataSourceRequest.Builder.() -> Unit) = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

    /**
     * Updates your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun updateExperience(input: UpdateExperienceRequest): UpdateExperienceResponse

    /**
     * Updates your Amazon Kendra experience such as a search application. For more information on
     * creating a search application experience, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html">Building a
     * search experience with no code.
     */
    suspend fun updateExperience(block: UpdateExperienceRequest.Builder.() -> Unit) = updateExperience(UpdateExperienceRequest.Builder().apply(block).build())

    /**
     * Updates an existing Amazon Kendra index.
     */
    suspend fun updateIndex(input: UpdateIndexRequest): UpdateIndexResponse

    /**
     * Updates an existing Amazon Kendra index.
     */
    suspend fun updateIndex(block: UpdateIndexRequest.Builder.() -> Unit) = updateIndex(UpdateIndexRequest.Builder().apply(block).build())

    /**
     * Updates a block list used for query suggestions for an index.
     * Updates to a block list might not take effect right away. Amazon Kendra
     * needs to refresh the entire suggestions list to apply any updates to the
     * block list. Other changes not related to the block list apply immediately.
     * If a block list is updating, then you need to wait for the first update to
     * finish before submitting another update.
     * Amazon Kendra supports partial updates, so you only need to provide the fields
     * you want to update.
     * UpdateQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun updateQuerySuggestionsBlockList(input: UpdateQuerySuggestionsBlockListRequest): UpdateQuerySuggestionsBlockListResponse

    /**
     * Updates a block list used for query suggestions for an index.
     * Updates to a block list might not take effect right away. Amazon Kendra
     * needs to refresh the entire suggestions list to apply any updates to the
     * block list. Other changes not related to the block list apply immediately.
     * If a block list is updating, then you need to wait for the first update to
     * finish before submitting another update.
     * Amazon Kendra supports partial updates, so you only need to provide the fields
     * you want to update.
     * UpdateQuerySuggestionsBlockList is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun updateQuerySuggestionsBlockList(block: UpdateQuerySuggestionsBlockListRequest.Builder.() -> Unit) = updateQuerySuggestionsBlockList(UpdateQuerySuggestionsBlockListRequest.Builder().apply(block).build())

    /**
     * Updates the settings of query suggestions for an index.
     * Amazon Kendra supports partial updates, so you only need to provide
     * the fields you want to update.
     * If an update is currently processing (i.e. 'happening'), you
     * need to wait for the update to finish before making another update.
     * Updates to query suggestions settings might not take effect right away.
     * The time for your updated settings to take effect depends on the updates
     * made and the number of search queries in your index.
     * You can still enable/disable query suggestions at any time.
     * UpdateQuerySuggestionsConfig is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun updateQuerySuggestionsConfig(input: UpdateQuerySuggestionsConfigRequest): UpdateQuerySuggestionsConfigResponse

    /**
     * Updates the settings of query suggestions for an index.
     * Amazon Kendra supports partial updates, so you only need to provide
     * the fields you want to update.
     * If an update is currently processing (i.e. 'happening'), you
     * need to wait for the update to finish before making another update.
     * Updates to query suggestions settings might not take effect right away.
     * The time for your updated settings to take effect depends on the updates
     * made and the number of search queries in your index.
     * You can still enable/disable query suggestions at any time.
     * UpdateQuerySuggestionsConfig is currently not supported in the
     * Amazon Web Services GovCloud (US-West) region.
     */
    suspend fun updateQuerySuggestionsConfig(block: UpdateQuerySuggestionsConfigRequest.Builder.() -> Unit) = updateQuerySuggestionsConfig(UpdateQuerySuggestionsConfigRequest.Builder().apply(block).build())

    /**
     * Updates a thesaurus file associated with an index.
     */
    suspend fun updateThesaurus(input: UpdateThesaurusRequest): UpdateThesaurusResponse

    /**
     * Updates a thesaurus file associated with an index.
     */
    suspend fun updateThesaurus(block: UpdateThesaurusRequest.Builder.() -> Unit) = updateThesaurus(UpdateThesaurusRequest.Builder().apply(block).build())
}
