// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides a response when the status of a document could not be retrieved.
 */
class BatchGetDocumentStatusResponseError private constructor(builder: Builder) {
    /**
     * The unique identifier of the document whose status could not be retrieved.
     */
    val documentId: kotlin.String? = builder.documentId
    /**
     * Indicates the source of the error.
     */
    val errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = builder.errorCode
    /**
     * States that the API could not get the status of a document. This could be
     * because the request is not valid or there is a system error.
     */
    val errorMessage: kotlin.String? = builder.errorMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetDocumentStatusResponseError(")
        append("documentId=$documentId,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentId?.hashCode() ?: 0
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetDocumentStatusResponseError

        if (documentId != other.documentId) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the document whose status could not be retrieved.
         */
        var documentId: kotlin.String? = null
        /**
         * Indicates the source of the error.
         */
        var errorCode: aws.sdk.kotlin.services.kendra.model.ErrorCode? = null
        /**
         * States that the API could not get the status of a document. This could be
         * because the request is not valid or there is a system error.
         */
        var errorMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError) : this() {
            this.documentId = x.documentId
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError = BatchGetDocumentStatusResponseError(this)
    }
}
