// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Specifies the attachment settings for the Confluence data source.
 * Attachment settings are optional, if you don't specify settings
 * attachments, Amazon Kendra won't index them.
 */
class ConfluenceAttachmentConfiguration private constructor(builder: Builder) {
    /**
     * Defines how attachment metadata fields should be mapped to index
     * fields. Before you can map a field, you must first create an index
     * field with a matching type using the console or the
     * UpdateIndex operation.
     * If you specify the AttachentFieldMappings parameter,
     * you must specify at least one field mapping.
     */
    val attachmentFieldMappings: List<ConfluenceAttachmentToIndexFieldMapping>? = builder.attachmentFieldMappings
    /**
     * Indicates whether Amazon Kendra indexes attachments to the pages and blogs
     * in the Confluence data source.
     */
    val crawlAttachments: kotlin.Boolean = builder.crawlAttachments

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceAttachmentConfiguration(")
        append("attachmentFieldMappings=$attachmentFieldMappings,")
        append("crawlAttachments=$crawlAttachments)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (crawlAttachments.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceAttachmentConfiguration

        if (attachmentFieldMappings != other.attachmentFieldMappings) return false
        if (crawlAttachments != other.crawlAttachments) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Defines how attachment metadata fields should be mapped to index
         * fields. Before you can map a field, you must first create an index
         * field with a matching type using the console or the
         * UpdateIndex operation.
         * If you specify the AttachentFieldMappings parameter,
         * you must specify at least one field mapping.
         */
        var attachmentFieldMappings: List<ConfluenceAttachmentToIndexFieldMapping>? = null
        /**
         * Indicates whether Amazon Kendra indexes attachments to the pages and blogs
         * in the Confluence data source.
         */
        var crawlAttachments: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration) : this() {
            this.attachmentFieldMappings = x.attachmentFieldMappings
            this.crawlAttachments = x.crawlAttachments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration = ConfluenceAttachmentConfiguration(this)
    }
}
