// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides configuration information for data sources that connect
 * to Confluence.
 */
class ConfluenceConfiguration private constructor(builder: Builder) {
    /**
     * Specifies configuration information for indexing attachments to
     * Confluence blogs and pages.
     */
    val attachmentConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration? = builder.attachmentConfiguration
    /**
     * Specifies configuration information for indexing Confluence
     * blogs.
     */
    val blogConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration? = builder.blogConfiguration
    /**
     * A list of regular expression patterns that apply to a URL on the
     * Confluence server. An exclusion pattern can apply to a blog post, a
     * page, a space, or an attachment. Items that match the pattern are
     * excluded from the index. Items that don't match the pattern are
     * included in the index. If a item matches both an exclusion pattern
     * and an inclusion pattern, the item isn't included in the
     * index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of regular expression patterns that apply to a URL on the
     * Confluence server. An inclusion pattern can apply to a blog post, a
     * page, a space, or an attachment. Items that match the patterns are
     * included in the index. Items that don't match the pattern are
     * excluded from the index. If an item matches both an inclusion
     * pattern and an exclusion pattern, the item isn't included in the
     * index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * Specifies configuration information for indexing Confluence
     * pages.
     */
    val pageConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration? = builder.pageConfiguration
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret
     * that contains the key/value pairs required to connect to your
     * Confluence server. The secret must contain a JSON structure with the
     * following keys:
     * username - The user name or email address of a user with
     * administrative privileges for the Confluence server.
     * password - The password associated with the user logging
     * in to the Confluence server.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The URL of your Confluence instance. Use the full URL of the
     * server. For example, https://server.example.com:port/.
     * You can also use an IP address, for example,
     * https://192.168.1.113/.
     */
    val serverUrl: kotlin.String? = builder.serverUrl
    /**
     * Specifies configuration information for indexing Confluence
     * spaces.
     */
    val spaceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration? = builder.spaceConfiguration
    /**
     * Specifies the version of the Confluence installation that you are
     * connecting to.
     */
    val version: aws.sdk.kotlin.services.kendra.model.ConfluenceVersion? = builder.version
    /**
     * Specifies the information for connecting to an Amazon VPC.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceConfiguration(")
        append("attachmentConfiguration=$attachmentConfiguration,")
        append("blogConfiguration=$blogConfiguration,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("pageConfiguration=$pageConfiguration,")
        append("secretArn=$secretArn,")
        append("serverUrl=$serverUrl,")
        append("spaceConfiguration=$spaceConfiguration,")
        append("version=$version,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentConfiguration?.hashCode() ?: 0
        result = 31 * result + (blogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (pageConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (serverUrl?.hashCode() ?: 0)
        result = 31 * result + (spaceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceConfiguration

        if (attachmentConfiguration != other.attachmentConfiguration) return false
        if (blogConfiguration != other.blogConfiguration) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (pageConfiguration != other.pageConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (serverUrl != other.serverUrl) return false
        if (spaceConfiguration != other.spaceConfiguration) return false
        if (version != other.version) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies configuration information for indexing attachments to
         * Confluence blogs and pages.
         */
        var attachmentConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration? = null
        /**
         * Specifies configuration information for indexing Confluence
         * blogs.
         */
        var blogConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration? = null
        /**
         * A list of regular expression patterns that apply to a URL on the
         * Confluence server. An exclusion pattern can apply to a blog post, a
         * page, a space, or an attachment. Items that match the pattern are
         * excluded from the index. Items that don't match the pattern are
         * included in the index. If a item matches both an exclusion pattern
         * and an inclusion pattern, the item isn't included in the
         * index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns that apply to a URL on the
         * Confluence server. An inclusion pattern can apply to a blog post, a
         * page, a space, or an attachment. Items that match the patterns are
         * included in the index. Items that don't match the pattern are
         * excluded from the index. If an item matches both an inclusion
         * pattern and an exclusion pattern, the item isn't included in the
         * index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * Specifies configuration information for indexing Confluence
         * pages.
         */
        var pageConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret
         * that contains the key/value pairs required to connect to your
         * Confluence server. The secret must contain a JSON structure with the
         * following keys:
         * username - The user name or email address of a user with
         * administrative privileges for the Confluence server.
         * password - The password associated with the user logging
         * in to the Confluence server.
         */
        var secretArn: kotlin.String? = null
        /**
         * The URL of your Confluence instance. Use the full URL of the
         * server. For example, https://server.example.com:port/.
         * You can also use an IP address, for example,
         * https://192.168.1.113/.
         */
        var serverUrl: kotlin.String? = null
        /**
         * Specifies configuration information for indexing Confluence
         * spaces.
         */
        var spaceConfiguration: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration? = null
        /**
         * Specifies the version of the Confluence installation that you are
         * connecting to.
         */
        var version: aws.sdk.kotlin.services.kendra.model.ConfluenceVersion? = null
        /**
         * Specifies the information for connecting to an Amazon VPC.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration) : this() {
            this.attachmentConfiguration = x.attachmentConfiguration
            this.blogConfiguration = x.blogConfiguration
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.pageConfiguration = x.pageConfiguration
            this.secretArn = x.secretArn
            this.serverUrl = x.serverUrl
            this.spaceConfiguration = x.spaceConfiguration
            this.version = x.version
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceConfiguration = ConfluenceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration] inside the given [block]
         */
        fun attachmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration.Builder.() -> kotlin.Unit) {
            this.attachmentConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceAttachmentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration] inside the given [block]
         */
        fun blogConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration.Builder.() -> kotlin.Unit) {
            this.blogConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceBlogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration] inside the given [block]
         */
        fun pageConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration.Builder.() -> kotlin.Unit) {
            this.pageConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluencePageConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration] inside the given [block]
         */
        fun spaceConfiguration(block: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration.Builder.() -> kotlin.Unit) {
            this.spaceConfiguration = aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
