// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Defines the mapping between a field in the Confluence data source
 * to a Amazon Kendra index field.
 * You must first create the index field using the
 * UpdateIndex operation.
 */
class ConfluenceSpaceToIndexFieldMapping private constructor(builder: Builder) {
    /**
     * The name of the field in the data source.
     */
    val dataSourceFieldName: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceFieldName? = builder.dataSourceFieldName
    /**
     * The format for date fields in the data source. If the field
     * specified in DataSourceFieldName is a date field you
     * must specify the date format. If the field is not a date field, an
     * exception is thrown.
     */
    val dateFieldFormat: kotlin.String? = builder.dateFieldFormat
    /**
     * The name of the index field to map to the Confluence data source
     * field. The index field type must match the Confluence field
     * type.
     */
    val indexFieldName: kotlin.String? = builder.indexFieldName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceToIndexFieldMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfluenceSpaceToIndexFieldMapping(")
        append("dataSourceFieldName=$dataSourceFieldName,")
        append("dateFieldFormat=$dateFieldFormat,")
        append("indexFieldName=$indexFieldName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceFieldName?.hashCode() ?: 0
        result = 31 * result + (dateFieldFormat?.hashCode() ?: 0)
        result = 31 * result + (indexFieldName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfluenceSpaceToIndexFieldMapping

        if (dataSourceFieldName != other.dataSourceFieldName) return false
        if (dateFieldFormat != other.dateFieldFormat) return false
        if (indexFieldName != other.indexFieldName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceToIndexFieldMapping = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the field in the data source.
         */
        var dataSourceFieldName: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceFieldName? = null
        /**
         * The format for date fields in the data source. If the field
         * specified in DataSourceFieldName is a date field you
         * must specify the date format. If the field is not a date field, an
         * exception is thrown.
         */
        var dateFieldFormat: kotlin.String? = null
        /**
         * The name of the index field to map to the Confluence data source
         * field. The index field type must match the Confluence field
         * type.
         */
        var indexFieldName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceToIndexFieldMapping) : this() {
            this.dataSourceFieldName = x.dataSourceFieldName
            this.dateFieldFormat = x.dateFieldFormat
            this.indexFieldName = x.indexFieldName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConfluenceSpaceToIndexFieldMapping = ConfluenceSpaceToIndexFieldMapping(this)
    }
}
