// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeQuerySuggestionsBlockListResponse private constructor(builder: Builder) {
    /**
     * Shows the date-time a block list for query suggestions was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Shows the description for the block list.
     */
    val description: kotlin.String? = builder.description
    /**
     * Shows the error message with details when there are issues in
     * processing the block list.
     */
    val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Shows the current size of the block list text file in S3.
     */
    val fileSizeBytes: kotlin.Long? = builder.fileSizeBytes
    /**
     * Shows the unique identifier of the block list.
     */
    val id: kotlin.String? = builder.id
    /**
     * Shows the identifier of the index for the block list.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * Shows the current number of valid, non-empty words or phrases in
     * the block list text file.
     */
    val itemCount: kotlin.Int? = builder.itemCount
    /**
     * Shows the name of the block list.
     */
    val name: kotlin.String? = builder.name
    /**
     * Shows the current IAM (Identity and Access Management) role used by
     * Amazon Kendra to access the block list text file in S3.
     * The role needs S3 read permissions to your file in S3 and needs to
     * give STS (Security Token Service) assume role permissions to
     * Amazon Kendra.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Shows the current S3 path to your block list text file in your S3 bucket.
     * Each block word or phrase should be on a separate line in a text file.
     * For information on the current quota limits for block lists, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
     * for Amazon Kendra.
     */
    val sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sourceS3Path
    /**
     * Shows whether the current status of the block list is
     * ACTIVE or INACTIVE.
     */
    val status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = builder.status
    /**
     * Shows the date-time a block list for query suggestions was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeQuerySuggestionsBlockListResponse(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("errorMessage=$errorMessage,")
        append("fileSizeBytes=$fileSizeBytes,")
        append("id=$id,")
        append("indexId=$indexId,")
        append("itemCount=$itemCount,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sourceS3Path=$sourceS3Path,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (fileSizeBytes?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Path?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeQuerySuggestionsBlockListResponse

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (errorMessage != other.errorMessage) return false
        if (fileSizeBytes != other.fileSizeBytes) return false
        if (id != other.id) return false
        if (indexId != other.indexId) return false
        if (itemCount != other.itemCount) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sourceS3Path != other.sourceS3Path) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Shows the date-time a block list for query suggestions was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Shows the description for the block list.
         */
        var description: kotlin.String? = null
        /**
         * Shows the error message with details when there are issues in
         * processing the block list.
         */
        var errorMessage: kotlin.String? = null
        /**
         * Shows the current size of the block list text file in S3.
         */
        var fileSizeBytes: kotlin.Long? = null
        /**
         * Shows the unique identifier of the block list.
         */
        var id: kotlin.String? = null
        /**
         * Shows the identifier of the index for the block list.
         */
        var indexId: kotlin.String? = null
        /**
         * Shows the current number of valid, non-empty words or phrases in
         * the block list text file.
         */
        var itemCount: kotlin.Int? = null
        /**
         * Shows the name of the block list.
         */
        var name: kotlin.String? = null
        /**
         * Shows the current IAM (Identity and Access Management) role used by
         * Amazon Kendra to access the block list text file in S3.
         * The role needs S3 read permissions to your file in S3 and needs to
         * give STS (Security Token Service) assume role permissions to
         * Amazon Kendra.
         */
        var roleArn: kotlin.String? = null
        /**
         * Shows the current S3 path to your block list text file in your S3 bucket.
         * Each block word or phrase should be on a separate line in a text file.
         * For information on the current quota limits for block lists, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
         * for Amazon Kendra.
         */
        var sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * Shows whether the current status of the block list is
         * ACTIVE or INACTIVE.
         */
        var status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = null
        /**
         * Shows the date-time a block list for query suggestions was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListResponse) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.errorMessage = x.errorMessage
            this.fileSizeBytes = x.fileSizeBytes
            this.id = x.id
            this.indexId = x.indexId
            this.itemCount = x.itemCount
            this.name = x.name
            this.roleArn = x.roleArn
            this.sourceS3Path = x.sourceS3Path
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListResponse = DescribeQuerySuggestionsBlockListResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        fun sourceS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sourceS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }
    }
}
