// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeQuerySuggestionsConfigResponse private constructor(builder: Builder) {
    /**
     * Shows whether Amazon Kendra uses all queries or only uses queries that
     * include user information to generate query suggestions.
     */
    val includeQueriesWithoutUserInformation: kotlin.Boolean? = builder.includeQueriesWithoutUserInformation
    /**
     * Shows the date-time query suggestions for an index was last cleared.
     * After you clear suggestions, Amazon Kendra learns new suggestions based
     * on new queries added to the query log from the time you cleared suggestions.
     * Amazon Kendra only considers re-occurences of a query from the time you cleared
     * suggestions.
     */
    val lastClearTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastClearTime
    /**
     * Shows the date-time query suggestions for an index was last updated.
     */
    val lastSuggestionsBuildTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuggestionsBuildTime
    /**
     * Shows the minimum number of unique users who must search a query in
     * order for the query to be eligible to suggest to your users.
     */
    val minimumNumberOfQueryingUsers: kotlin.Int? = builder.minimumNumberOfQueryingUsers
    /**
     * Shows the minimum number of times a query must be searched in order for
     * the query to be eligible to suggest to your users.
     */
    val minimumQueryCount: kotlin.Int? = builder.minimumQueryCount
    /**
     * Shows whether query suggestions are currently in
     * ENABLED mode or LEARN_ONLY mode.
     * By default, Amazon Kendra enables query suggestions.LEARN_ONLY
     * turns off query suggestions for your users. You can change the mode using
     * the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig
     * operation.
     */
    val mode: aws.sdk.kotlin.services.kendra.model.Mode? = builder.mode
    /**
     * Shows how recent your queries are in your query log time
     * window (in days).
     */
    val queryLogLookBackWindowInDays: kotlin.Int? = builder.queryLogLookBackWindowInDays
    /**
     * Shows whether the status of query suggestions settings is currently
     * Active or Updating.
     * Active means the current settings apply and Updating means your
     * changed settings are in the process of applying.
     */
    val status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus? = builder.status
    /**
     * Shows the current total count of query suggestions for an index.
     * This count can change when you update your query suggestions settings,
     * if you filter out certain queries from suggestions using a block list,
     * and as the query log accumulates more queries for Amazon Kendra to learn from.
     */
    val totalSuggestionsCount: kotlin.Int? = builder.totalSuggestionsCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeQuerySuggestionsConfigResponse(")
        append("includeQueriesWithoutUserInformation=$includeQueriesWithoutUserInformation,")
        append("lastClearTime=$lastClearTime,")
        append("lastSuggestionsBuildTime=$lastSuggestionsBuildTime,")
        append("minimumNumberOfQueryingUsers=$minimumNumberOfQueryingUsers,")
        append("minimumQueryCount=$minimumQueryCount,")
        append("mode=$mode,")
        append("queryLogLookBackWindowInDays=$queryLogLookBackWindowInDays,")
        append("status=$status,")
        append("totalSuggestionsCount=$totalSuggestionsCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeQueriesWithoutUserInformation?.hashCode() ?: 0
        result = 31 * result + (lastClearTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuggestionsBuildTime?.hashCode() ?: 0)
        result = 31 * result + (minimumNumberOfQueryingUsers ?: 0)
        result = 31 * result + (minimumQueryCount ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (queryLogLookBackWindowInDays ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalSuggestionsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeQuerySuggestionsConfigResponse

        if (includeQueriesWithoutUserInformation != other.includeQueriesWithoutUserInformation) return false
        if (lastClearTime != other.lastClearTime) return false
        if (lastSuggestionsBuildTime != other.lastSuggestionsBuildTime) return false
        if (minimumNumberOfQueryingUsers != other.minimumNumberOfQueryingUsers) return false
        if (minimumQueryCount != other.minimumQueryCount) return false
        if (mode != other.mode) return false
        if (queryLogLookBackWindowInDays != other.queryLogLookBackWindowInDays) return false
        if (status != other.status) return false
        if (totalSuggestionsCount != other.totalSuggestionsCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Shows whether Amazon Kendra uses all queries or only uses queries that
         * include user information to generate query suggestions.
         */
        var includeQueriesWithoutUserInformation: kotlin.Boolean? = null
        /**
         * Shows the date-time query suggestions for an index was last cleared.
         * After you clear suggestions, Amazon Kendra learns new suggestions based
         * on new queries added to the query log from the time you cleared suggestions.
         * Amazon Kendra only considers re-occurences of a query from the time you cleared
         * suggestions.
         */
        var lastClearTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Shows the date-time query suggestions for an index was last updated.
         */
        var lastSuggestionsBuildTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Shows the minimum number of unique users who must search a query in
         * order for the query to be eligible to suggest to your users.
         */
        var minimumNumberOfQueryingUsers: kotlin.Int? = null
        /**
         * Shows the minimum number of times a query must be searched in order for
         * the query to be eligible to suggest to your users.
         */
        var minimumQueryCount: kotlin.Int? = null
        /**
         * Shows whether query suggestions are currently in
         * ENABLED mode or LEARN_ONLY mode.
         * By default, Amazon Kendra enables query suggestions.LEARN_ONLY
         * turns off query suggestions for your users. You can change the mode using
         * the <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html">UpdateQuerySuggestionsConfig
         * operation.
         */
        var mode: aws.sdk.kotlin.services.kendra.model.Mode? = null
        /**
         * Shows how recent your queries are in your query log time
         * window (in days).
         */
        var queryLogLookBackWindowInDays: kotlin.Int? = null
        /**
         * Shows whether the status of query suggestions settings is currently
         * Active or Updating.
         * Active means the current settings apply and Updating means your
         * changed settings are in the process of applying.
         */
        var status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus? = null
        /**
         * Shows the current total count of query suggestions for an index.
         * This count can change when you update your query suggestions settings,
         * if you filter out certain queries from suggestions using a block list,
         * and as the query log accumulates more queries for Amazon Kendra to learn from.
         */
        var totalSuggestionsCount: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse) : this() {
            this.includeQueriesWithoutUserInformation = x.includeQueriesWithoutUserInformation
            this.lastClearTime = x.lastClearTime
            this.lastSuggestionsBuildTime = x.lastSuggestionsBuildTime
            this.minimumNumberOfQueryingUsers = x.minimumNumberOfQueryingUsers
            this.minimumQueryCount = x.minimumQueryCount
            this.mode = x.mode
            this.queryLogLookBackWindowInDays = x.queryLogLookBackWindowInDays
            this.status = x.status
            this.totalSuggestionsCount = x.totalSuggestionsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse = DescribeQuerySuggestionsConfigResponse(this)
    }
}
