// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a frequently asked questions and answer
 * contained in an index.
 */
class FaqSummary private constructor(builder: Builder) {
    /**
     * The UNIX datetime that the FAQ was added to the index.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The file type used to create the FAQ.
     */
    val fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = builder.fileFormat
    /**
     * The unique identifier of the FAQ.
     */
    val id: kotlin.String? = builder.id
    /**
     * The code for a language. This shows a supported language for the FAQ document
     * as part of the summary information for FAQs. English is supported by default.
     * For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
     * documents in languages other than English.
     */
    val languageCode: kotlin.String? = builder.languageCode
    /**
     * The name that you assigned the FAQ when you created or updated the
     * FAQ.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current status of the FAQ. When the status is
     * ACTIVE the FAQ is ready for use.
     */
    val status: aws.sdk.kotlin.services.kendra.model.FaqStatus? = builder.status
    /**
     * The UNIX datetime that the FAQ was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FaqSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FaqSummary(")
        append("createdAt=$createdAt,")
        append("fileFormat=$fileFormat,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (fileFormat?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FaqSummary

        if (createdAt != other.createdAt) return false
        if (fileFormat != other.fileFormat) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FaqSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The UNIX datetime that the FAQ was added to the index.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The file type used to create the FAQ.
         */
        var fileFormat: aws.sdk.kotlin.services.kendra.model.FaqFileFormat? = null
        /**
         * The unique identifier of the FAQ.
         */
        var id: kotlin.String? = null
        /**
         * The code for a language. This shows a supported language for the FAQ document
         * as part of the summary information for FAQs. English is supported by default.
         * For more information on supported languages, including their codes,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
         * documents in languages other than English.
         */
        var languageCode: kotlin.String? = null
        /**
         * The name that you assigned the FAQ when you created or updated the
         * FAQ.
         */
        var name: kotlin.String? = null
        /**
         * The current status of the FAQ. When the status is
         * ACTIVE the FAQ is ready for use.
         */
        var status: aws.sdk.kotlin.services.kendra.model.FaqStatus? = null
        /**
         * The UNIX datetime that the FAQ was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FaqSummary) : this() {
            this.createdAt = x.createdAt
            this.fileFormat = x.fileFormat
            this.id = x.id
            this.languageCode = x.languageCode
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FaqSummary = FaqSummary(this)
    }
}
