// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides configuration information for data sources that connect
 * to OneDrive.
 */
class OneDriveConfiguration private constructor(builder: Builder) {
    /**
     * A Boolean value that specifies whether local
     * groups are disabled (True) or enabled (False).
     */
    val disableLocalGroups: kotlin.Boolean = builder.disableLocalGroups
    /**
     * List of regular expressions applied to documents. Items that match
     * the exclusion pattern are not indexed. If you provide both an
     * inclusion pattern and an exclusion pattern, any item that matches
     * the exclusion pattern isn't indexed.
     * The exclusion pattern is applied to the file name.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of DataSourceToIndexFieldMapping objects that
     * map Microsoft OneDrive fields to custom fields in the Amazon Kendra
     * index. You must first create the index fields before you map
     * OneDrive fields.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns. Documents that match the
     * pattern are included in the index. Documents that don't match the
     * pattern are excluded from the index. If a document matches both an
     * inclusion pattern and an exclusion pattern, the document is not
     * included in the index.
     * The exclusion pattern is applied to the file name.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of user accounts whose documents should be indexed.
     */
    val oneDriveUsers: aws.sdk.kotlin.services.kendra.model.OneDriveUsers? = builder.oneDriveUsers
    /**
     * The Amazon Resource Name (ARN) of an Secrets Managersecret
     * that contains the user name and password to connect to OneDrive. The
     * user namd should be the application ID for the OneDrive application,
     * and the password is the application key for the OneDrive
     * application.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The Azure Active Directory domain of the organization.
     */
    val tenantDomain: kotlin.String? = builder.tenantDomain

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OneDriveConfiguration(")
        append("disableLocalGroups=$disableLocalGroups,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("oneDriveUsers=$oneDriveUsers,")
        append("secretArn=$secretArn,")
        append("tenantDomain=$tenantDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = disableLocalGroups.hashCode()
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (oneDriveUsers?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (tenantDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OneDriveConfiguration

        if (disableLocalGroups != other.disableLocalGroups) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (oneDriveUsers != other.oneDriveUsers) return false
        if (secretArn != other.secretArn) return false
        if (tenantDomain != other.tenantDomain) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A Boolean value that specifies whether local
         * groups are disabled (True) or enabled (False).
         */
        var disableLocalGroups: kotlin.Boolean = false
        /**
         * List of regular expressions applied to documents. Items that match
         * the exclusion pattern are not indexed. If you provide both an
         * inclusion pattern and an exclusion pattern, any item that matches
         * the exclusion pattern isn't indexed.
         * The exclusion pattern is applied to the file name.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that
         * map Microsoft OneDrive fields to custom fields in the Amazon Kendra
         * index. You must first create the index fields before you map
         * OneDrive fields.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns. Documents that match the
         * pattern are included in the index. Documents that don't match the
         * pattern are excluded from the index. If a document matches both an
         * inclusion pattern and an exclusion pattern, the document is not
         * included in the index.
         * The exclusion pattern is applied to the file name.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * A list of user accounts whose documents should be indexed.
         */
        var oneDriveUsers: aws.sdk.kotlin.services.kendra.model.OneDriveUsers? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Managersecret
         * that contains the user name and password to connect to OneDrive. The
         * user namd should be the application ID for the OneDrive application,
         * and the password is the application key for the OneDrive
         * application.
         */
        var secretArn: kotlin.String? = null
        /**
         * The Azure Active Directory domain of the organization.
         */
        var tenantDomain: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration) : this() {
            this.disableLocalGroups = x.disableLocalGroups
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.oneDriveUsers = x.oneDriveUsers
            this.secretArn = x.secretArn
            this.tenantDomain = x.tenantDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.OneDriveConfiguration = OneDriveConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.OneDriveUsers] inside the given [block]
         */
        fun oneDriveUsers(block: aws.sdk.kotlin.services.kendra.model.OneDriveUsers.Builder.() -> kotlin.Unit) {
            this.oneDriveUsers = aws.sdk.kotlin.services.kendra.model.OneDriveUsers.invoke(block)
        }
    }
}
