// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for a web proxy to connect to
 * website hosts.
 */
class ProxyConfiguration private constructor(builder: Builder) {
    /**
     * Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager
     * The credentials are optional. You use a secret if web proxy credentials
     * are required to connect to a website host. Amazon Kendra currently support basic
     * authentication to connect to a web proxy server. The secret stores your
     * credentials.
     */
    val credentials: kotlin.String? = builder.credentials
    /**
     * The name of the website host you want to connect to
     * via a web proxy server.
     * For example, the host name of https://a.example.com/page1.html
     * is "a.example.com".
     */
    val host: kotlin.String? = builder.host
    /**
     * The port number of the website host you want to connect
     * to via a web proxy server.
     * For example, the port for https://a.example.com/page1.html
     * is 443, the standard port for HTTPS.
     */
    val port: kotlin.Int? = builder.port

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ProxyConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProxyConfiguration(")
        append("credentials=$credentials,")
        append("host=$host,")
        append("port=$port)")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentials?.hashCode() ?: 0
        result = 31 * result + (host?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProxyConfiguration

        if (credentials != other.credentials) return false
        if (host != other.host) return false
        if (port != other.port) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ProxyConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Your secret ARN, which you can create in <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager
         * The credentials are optional. You use a secret if web proxy credentials
         * are required to connect to a website host. Amazon Kendra currently support basic
         * authentication to connect to a web proxy server. The secret stores your
         * credentials.
         */
        var credentials: kotlin.String? = null
        /**
         * The name of the website host you want to connect to
         * via a web proxy server.
         * For example, the host name of https://a.example.com/page1.html
         * is "a.example.com".
         */
        var host: kotlin.String? = null
        /**
         * The port number of the website host you want to connect
         * to via a web proxy server.
         * For example, the port for https://a.example.com/page1.html
         * is 443, the standard port for HTTPS.
         */
        var port: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ProxyConfiguration) : this() {
            this.credentials = x.credentials
            this.host = x.host
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ProxyConfiguration = ProxyConfiguration(this)
    }
}
