// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information on a query suggestions block list.
 * This includes information on the block list ID, block list name, when the
 * block list was created, when the block list was last updated, and the count
 * of block words/phrases in the block list.
 * For information on the current quota limits for block lists, see
 * <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas
 * for Amazon Kendra.
 */
class QuerySuggestionsBlockListSummary private constructor(builder: Builder) {
    /**
     * The date-time summary information for a query suggestions
     * block list was last created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The identifier of a block list.
     */
    val id: kotlin.String? = builder.id
    /**
     * The number of items in the block list file.
     */
    val itemCount: kotlin.Int? = builder.itemCount
    /**
     * The name of the block list.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of the block list.
     */
    val status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = builder.status
    /**
     * The date-time the block list was last updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QuerySuggestionsBlockListSummary(")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("itemCount=$itemCount,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (itemCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QuerySuggestionsBlockListSummary

        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (itemCount != other.itemCount) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date-time summary information for a query suggestions
         * block list was last created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of a block list.
         */
        var id: kotlin.String? = null
        /**
         * The number of items in the block list file.
         */
        var itemCount: kotlin.Int? = null
        /**
         * The name of the block list.
         */
        var name: kotlin.String? = null
        /**
         * The status of the block list.
         */
        var status: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListStatus? = null
        /**
         * The date-time the block list was last updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary) : this() {
            this.createdAt = x.createdAt
            this.id = x.id
            this.itemCount = x.itemCount
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QuerySuggestionsBlockListSummary = QuerySuggestionsBlockListSummary(this)
    }
}
