// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class UpdateDataSourceRequest private constructor(builder: Builder) {
    /**
     * Configuration information for an Amazon Kendra data source.
     */
    val configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = builder.configuration
    /**
     * Configuration information for altering document metadata and content during the
     * document ingestion process when you update a data source.
     * For more information on how to create, modify and delete document metadata, or make
     * other content alterations when you ingest documents into Amazon Kendra, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
     * document metadata during the ingestion process.
     */
    val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * The new description for the data source.
     */
    val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the data source to update.
     */
    val id: kotlin.String? = builder.id
    /**
     * The identifier of the index that contains the data source to
     * update.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The code for a language. This allows you to support a language for all
     * documents when updating the data source. English is supported
     * by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
     * documents in languages other than English.
     */
    val languageCode: kotlin.String? = builder.languageCode
    /**
     * The name of the data source to update. The name of the data source
     * can't be updated. To rename a data source you must delete the data source
     * and re-create it.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the new role to use when the data
     * source is accessing resources on your behalf.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The new update schedule for the data source.
     */
    val schedule: kotlin.String? = builder.schedule

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UpdateDataSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDataSourceRequest(")
        append("configuration=$configuration,")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("description=$description,")
        append("id=$id,")
        append("indexId=$indexId,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (customDocumentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDataSourceRequest

        if (configuration != other.configuration) return false
        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (indexId != other.indexId) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UpdateDataSourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration information for an Amazon Kendra data source.
         */
        var configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = null
        /**
         * Configuration information for altering document metadata and content during the
         * document ingestion process when you update a data source.
         * For more information on how to create, modify and delete document metadata, or make
         * other content alterations when you ingest documents into Amazon Kendra, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
         * document metadata during the ingestion process.
         */
        var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * The new description for the data source.
         */
        var description: kotlin.String? = null
        /**
         * The unique identifier of the data source to update.
         */
        var id: kotlin.String? = null
        /**
         * The identifier of the index that contains the data source to
         * update.
         */
        var indexId: kotlin.String? = null
        /**
         * The code for a language. This allows you to support a language for all
         * documents when updating the data source. English is supported
         * by default. For more information on supported languages, including their codes,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
         * documents in languages other than English.
         */
        var languageCode: kotlin.String? = null
        /**
         * The name of the data source to update. The name of the data source
         * can't be updated. To rename a data source you must delete the data source
         * and re-create it.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the new role to use when the data
         * source is accessing resources on your behalf.
         */
        var roleArn: kotlin.String? = null
        /**
         * The new update schedule for the data source.
         */
        var schedule: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UpdateDataSourceRequest) : this() {
            this.configuration = x.configuration
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.description = x.description
            this.id = x.id
            this.indexId = x.indexId
            this.languageCode = x.languageCode
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UpdateDataSourceRequest = UpdateDataSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }
    }
}
