// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.paginators

import aws.sdk.kotlin.services.kendra.KendraClient
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasRequest
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasResponse
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesResponse
import aws.sdk.kotlin.services.kendra.model.ListExperiencesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperiencesResponse
import aws.sdk.kotlin.services.kendra.model.ListIndicesRequest
import aws.sdk.kotlin.services.kendra.model.ListIndicesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetSnapshotsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [GetSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSnapshotsResponse]
 */
fun KendraClient.getSnapshotsPaginated(initialRequest: GetSnapshotsRequest): Flow<GetSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSnapshotsPaginated.getSnapshots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
fun KendraClient.listDataSourcesPaginated(initialRequest: ListDataSourcesRequest): Flow<ListDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourcesPaginated.listDataSources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourceSyncJobsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListDataSourceSyncJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceSyncJobsResponse]
 */
fun KendraClient.listDataSourceSyncJobsPaginated(initialRequest: ListDataSourceSyncJobsRequest): Flow<ListDataSourceSyncJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourceSyncJobsPaginated.listDataSourceSyncJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEntityPersonasResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListEntityPersonasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityPersonasResponse]
 */
fun KendraClient.listEntityPersonasPaginated(initialRequest: ListEntityPersonasRequest): Flow<ListEntityPersonasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntityPersonasPaginated.listEntityPersonas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperienceEntitiesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListExperienceEntitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperienceEntitiesResponse]
 */
fun KendraClient.listExperienceEntitiesPaginated(initialRequest: ListExperienceEntitiesRequest): Flow<ListExperienceEntitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperienceEntitiesPaginated.listExperienceEntities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperiencesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListExperiencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperiencesResponse]
 */
fun KendraClient.listExperiencesPaginated(initialRequest: ListExperiencesRequest): Flow<ListExperiencesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperiencesPaginated.listExperiences(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIndicesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListIndicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndicesResponse]
 */
fun KendraClient.listIndicesPaginated(initialRequest: ListIndicesRequest): Flow<ListIndicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIndicesPaginated.listIndices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }
