// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponse
import aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponseError
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.Status
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetDocumentStatusOperationDeserializer: HttpDeserialize<BatchGetDocumentStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetDocumentStatusResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetDocumentStatusError(context, response)
        }
        val builder = BatchGetDocumentStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetDocumentStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeBatchGetDocumentStatusOperationBody(builder: BatchGetDocumentStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOCUMENTSTATUSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DocumentStatusList"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOCUMENTSTATUSLIST_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOCUMENTSTATUSLIST_DESCRIPTOR.index -> builder.documentStatusList =
                    deserializer.deserializeList(DOCUMENTSTATUSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Status>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStatusDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetDocumentStatusResponseError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetDocumentStatusResponseErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwBatchGetDocumentStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw KendraException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
