// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kendra.model.DescribeFaqResponse
import aws.sdk.kotlin.services.kendra.model.FaqFileFormat
import aws.sdk.kotlin.services.kendra.model.FaqStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.S3Path
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeFaqOperationDeserializer: HttpDeserialize<DescribeFaqResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFaqResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFaqError(context, response)
        }
        val builder = DescribeFaqResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFaqOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeFaqOperationBody(builder: DescribeFaqResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val FILEFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileFormat"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val LANGUAGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LanguageCode"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val S3PATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3Path"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(FILEFORMAT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(LANGUAGECODE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(S3PATH_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                FILEFORMAT_DESCRIPTOR.index -> builder.fileFormat = deserializeString().let { FaqFileFormat.fromValue(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                LANGUAGECODE_DESCRIPTOR.index -> builder.languageCode = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                S3PATH_DESCRIPTOR.index -> builder.s3Path = deserializeS3PathDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FaqStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeFaqError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw KendraException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
