// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kendra.model.FacetResult
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.QueryResponse
import aws.sdk.kotlin.services.kendra.model.QueryResultItem
import aws.sdk.kotlin.services.kendra.model.Warning
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryOperationDeserializer: HttpDeserialize<QueryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): QueryResponse {
        if (!response.status.isSuccess()) {
            throwQueryError(context, response)
        }
        val builder = QueryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeQueryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeQueryOperationBody(builder: QueryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACETRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FacetResults"))
    val QUERYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryId"))
    val RESULTITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultItems"))
    val TOTALNUMBEROFRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalNumberOfResults"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACETRESULTS_DESCRIPTOR)
        field(QUERYID_DESCRIPTOR)
        field(RESULTITEMS_DESCRIPTOR)
        field(TOTALNUMBEROFRESULTS_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACETRESULTS_DESCRIPTOR.index -> builder.facetResults =
                    deserializer.deserializeList(FACETRESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FacetResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFacetResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                QUERYID_DESCRIPTOR.index -> builder.queryId = deserializeString()
                RESULTITEMS_DESCRIPTOR.index -> builder.resultItems =
                    deserializer.deserializeList(RESULTITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryResultItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryResultItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALNUMBEROFRESULTS_DESCRIPTOR.index -> builder.totalNumberOfResults = deserializeInt()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Warning>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWarningDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwQueryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw KendraException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
