// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class BatchPutDocumentRequest private constructor(builder: Builder) {
    /**
     * Configuration information for altering your document metadata and content during
     * the document ingestion process when you use the BatchPutDocument
     * API.
     * For more information on how to create, modify and delete document metadata,
     * or make other content alterations when you ingest documents into Amazon Kendra, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
     * document metadata during the ingestion process.
     */
    val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * One or more documents to add to the index.
     * Documents have the following file size limits.
     *
     *
     * 5 MB total size for inline documents
     *
     * 50 MB total size for files from an S3 bucket
     *
     * 5 MB extracted text for any file
     *
     *
     * For more information about file size and transaction per second
     * quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas.
     */
    val documents: List<Document>? = builder.documents
    /**
     * The identifier of the index to add the documents to. You need to
     * create the index first using the CreateIndex
     * API.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The Amazon Resource Name (ARN) of a role that is allowed to run the
     * BatchPutDocument API. For more information, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM
     * Roles for Amazon Kendra.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPutDocumentRequest(")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("documents=$documents,")
        append("indexId=$indexId,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDocumentEnrichmentConfiguration?.hashCode() ?: 0
        result = 31 * result + (documents?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPutDocumentRequest

        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (documents != other.documents) return false
        if (indexId != other.indexId) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration information for altering your document metadata and content during
         * the document ingestion process when you use the BatchPutDocument
         * API.
         * For more information on how to create, modify and delete document metadata,
         * or make other content alterations when you ingest documents into Amazon Kendra, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
         * document metadata during the ingestion process.
         */
        var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * One or more documents to add to the index.
         * Documents have the following file size limits.
         *
         *
         * 5 MB total size for inline documents
         *
         * 50 MB total size for files from an S3 bucket
         *
         * 5 MB extracted text for any file
         *
         *
         * For more information about file size and transaction per second
         * quotas, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/quotas.html">Quotas.
         */
        var documents: List<Document>? = null
        /**
         * The identifier of the index to add the documents to. You need to
         * create the index first using the CreateIndex
         * API.
         */
        var indexId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a role that is allowed to run the
         * BatchPutDocument API. For more information, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM
         * Roles for Amazon Kendra.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest) : this() {
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.documents = x.documents
            this.indexId = x.indexId
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = BatchPutDocumentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }
    }
}
