// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for your content sources, such as data sources,
 * FAQs, and content indexed directly via <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html">BatchPutDocument.
 */
class ContentSourceConfiguration private constructor(builder: Builder) {
    /**
     * The identifier of the data sources you want to use for your Amazon Kendra experience.
     */
    val dataSourceIds: List<String>? = builder.dataSourceIds
    /**
     * TRUE to use documents you indexed directly using the
     * BatchPutDocument API.
     */
    val directPutContent: kotlin.Boolean = builder.directPutContent
    /**
     * The identifier of the FAQs that you want to use for your Amazon Kendra experience.
     */
    val faqIds: List<String>? = builder.faqIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContentSourceConfiguration(")
        append("dataSourceIds=$dataSourceIds,")
        append("directPutContent=$directPutContent,")
        append("faqIds=$faqIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceIds?.hashCode() ?: 0
        result = 31 * result + (directPutContent.hashCode())
        result = 31 * result + (faqIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContentSourceConfiguration

        if (dataSourceIds != other.dataSourceIds) return false
        if (directPutContent != other.directPutContent) return false
        if (faqIds != other.faqIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the data sources you want to use for your Amazon Kendra experience.
         */
        var dataSourceIds: List<String>? = null
        /**
         * TRUE to use documents you indexed directly using the
         * BatchPutDocument API.
         */
        var directPutContent: kotlin.Boolean = false
        /**
         * The identifier of the FAQs that you want to use for your Amazon Kendra experience.
         */
        var faqIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration) : this() {
            this.dataSourceIds = x.dataSourceIds
            this.directPutContent = x.directPutContent
            this.faqIds = x.faqIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration = ContentSourceConfiguration(this)
    }
}
