// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class CreateDataSourceRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a data
     * source. Multiple calls to the CreateDataSource API with
     * the same client token will create only one data source.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration information that is required to access the data source
     * repository.
     * You can't specify the Configuration parameter when the
     * Type parameter is set to CUSTOM. If you do,
     * you receive a ValidationException exception.
     * The Configuration parameter is required for all other
     * data sources.
     */
    val configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = builder.configuration
    /**
     * Configuration information for altering document metadata and content during the
     * document ingestion process when you create a data source.
     * For more information on how to create, modify and delete document metadata, or make
     * other content alterations when you ingest documents into Amazon Kendra, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
     * document metadata during the ingestion process.
     */
    val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * A description for the data source.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the index that should be associated with this data
     * source.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The code for a language. This allows you to support a language for all
     * documents when creating the data source. English is supported
     * by default. For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
     * documents in languages other than English.
     */
    val languageCode: kotlin.String? = builder.languageCode
    /**
     * A unique name for the data source. A data source name can't be changed
     * without deleting and recreating the data source.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the
     * data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
     * Amazon Kendra.
     * You can't specify the RoleArn parameter when the
     * Type parameter is set to CUSTOM. If you do,
     * you receive a ValidationException exception.
     * The RoleArn parameter is required for all other data
     * sources.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Sets the frequency for Amazon Kendra to check the documents in your
     * repository and update the index. If you don't set a schedule Amazon Kendra
     * will not periodically update the index. You can call the
     * StartDataSourceSyncJob API to update the
     * index.
     * You can't specify the Schedule parameter when the
     * Type parameter is set to CUSTOM. If you do,
     * you receive a ValidationException exception.
     */
    val schedule: kotlin.String? = builder.schedule
    /**
     * A list of key-value pairs that identify the data source. You can use
     * the tags to identify and organize your resources and to control access to
     * resources.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of repository that contains the data source.
     */
    val type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceRequest(")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (customDocumentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceRequest

        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A token that you provide to identify the request to create a data
         * source. Multiple calls to the CreateDataSource API with
         * the same client token will create only one data source.
         */
        var clientToken: kotlin.String? = null
        /**
         * Configuration information that is required to access the data source
         * repository.
         * You can't specify the Configuration parameter when the
         * Type parameter is set to CUSTOM. If you do,
         * you receive a ValidationException exception.
         * The Configuration parameter is required for all other
         * data sources.
         */
        var configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = null
        /**
         * Configuration information for altering document metadata and content during the
         * document ingestion process when you create a data source.
         * For more information on how to create, modify and delete document metadata, or make
         * other content alterations when you ingest documents into Amazon Kendra, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html">Customizing
         * document metadata during the ingestion process.
         */
        var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * A description for the data source.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the index that should be associated with this data
         * source.
         */
        var indexId: kotlin.String? = null
        /**
         * The code for a language. This allows you to support a language for all
         * documents when creating the data source. English is supported
         * by default. For more information on supported languages, including their codes,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
         * documents in languages other than English.
         */
        var languageCode: kotlin.String? = null
        /**
         * A unique name for the data source. A data source name can't be changed
         * without deleting and recreating the data source.
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a role with permission to access the
         * data source. For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html">IAM Roles for
         * Amazon Kendra.
         * You can't specify the RoleArn parameter when the
         * Type parameter is set to CUSTOM. If you do,
         * you receive a ValidationException exception.
         * The RoleArn parameter is required for all other data
         * sources.
         */
        var roleArn: kotlin.String? = null
        /**
         * Sets the frequency for Amazon Kendra to check the documents in your
         * repository and update the index. If you don't set a schedule Amazon Kendra
         * will not periodically update the index. You can call the
         * StartDataSourceSyncJob API to update the
         * index.
         * You can't specify the Schedule parameter when the
         * Type parameter is set to CUSTOM. If you do,
         * you receive a ValidationException exception.
         */
        var schedule: kotlin.String? = null
        /**
         * A list of key-value pairs that identify the data source. You can use
         * the tags to identify and organize your resources and to control access to
         * resources.
         */
        var tags: List<Tag>? = null
        /**
         * The type of repository that contains the data source.
         */
        var type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest) : this() {
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.description = x.description
            this.indexId = x.indexId
            this.languageCode = x.languageCode
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = CreateDataSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration] inside the given [block]
         */
        fun configuration(block: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }
    }
}
