// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class CreateThesaurusRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a
     * thesaurus. Multiple calls to the CreateThesaurus API
     * with the same client token will create only one thesaurus.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description for the new thesaurus.
     */
    val description: kotlin.String? = builder.description
    /**
     * The unique identifier of the index for the new thesaurus.
     */
    val indexId: kotlin.String? = builder.indexId
    /**
     * The name for the new thesaurus.
     */
    val name: kotlin.String? = builder.name
    /**
     * An IAM role that gives Amazon Kendra permissions
     * to access thesaurus file specified in SourceS3Path.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The thesaurus file Amazon S3 source path.
     */
    val sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sourceS3Path
    /**
     * A list of key-value pairs that identify the thesaurus. You can use
     * the tags to identify and organize your resources and to control
     * access to resources.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateThesaurusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateThesaurusRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("sourceS3Path=$sourceS3Path,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (sourceS3Path?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateThesaurusRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (sourceS3Path != other.sourceS3Path) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateThesaurusRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A token that you provide to identify the request to create a
         * thesaurus. Multiple calls to the CreateThesaurus API
         * with the same client token will create only one thesaurus.
         */
        var clientToken: kotlin.String? = null
        /**
         * The description for the new thesaurus.
         */
        var description: kotlin.String? = null
        /**
         * The unique identifier of the index for the new thesaurus.
         */
        var indexId: kotlin.String? = null
        /**
         * The name for the new thesaurus.
         */
        var name: kotlin.String? = null
        /**
         * An IAM role that gives Amazon Kendra permissions
         * to access thesaurus file specified in SourceS3Path.
         */
        var roleArn: kotlin.String? = null
        /**
         * The thesaurus file Amazon S3 source path.
         */
        var sourceS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * A list of key-value pairs that identify the thesaurus. You can use
         * the tags to identify and organize your resources and to control
         * access to resources.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateThesaurusRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.indexId = x.indexId
            this.name = x.name
            this.roleArn = x.roleArn
            this.sourceS3Path = x.sourceS3Path
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateThesaurusRequest = CreateThesaurusRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        fun sourceS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sourceS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }
    }
}
