// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information for an Amazon Kendra data source. Returned in a call
 * to the DescribeDataSource API.
 */
class DataSourceSummary private constructor(builder: Builder) {
    /**
     * The UNIX datetime that the data source was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The unique identifier for the data source.
     */
    val id: kotlin.String? = builder.id
    /**
     * The code for a language. This shows a supported language for all documents
     * in the data source. English is supported by default.
     * For more information on supported languages, including their codes,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
     * documents in languages other than English.
     */
    val languageCode: kotlin.String? = builder.languageCode
    /**
     * The name of the data source.
     */
    val name: kotlin.String? = builder.name
    /**
     * The status of the data source. When the status is
     * ACTIVE the data source is ready to use.
     */
    val status: aws.sdk.kotlin.services.kendra.model.DataSourceStatus? = builder.status
    /**
     * The type of the data source.
     */
    val type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = builder.type
    /**
     * The UNIX datetime that the data source was lasted updated.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceSummary(")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("status=$status,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceSummary

        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The UNIX datetime that the data source was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the data source.
         */
        var id: kotlin.String? = null
        /**
         * The code for a language. This shows a supported language for all documents
         * in the data source. English is supported by default.
         * For more information on supported languages, including their codes,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html">Adding
         * documents in languages other than English.
         */
        var languageCode: kotlin.String? = null
        /**
         * The name of the data source.
         */
        var name: kotlin.String? = null
        /**
         * The status of the data source. When the status is
         * ACTIVE the data source is ready to use.
         */
        var status: aws.sdk.kotlin.services.kendra.model.DataSourceStatus? = null
        /**
         * The type of the data source.
         */
        var type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = null
        /**
         * The UNIX datetime that the data source was lasted updated.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceSummary) : this() {
            this.createdAt = x.createdAt
            this.id = x.id
            this.languageCode = x.languageCode
            this.name = x.name
            this.status = x.status
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceSummary = DataSourceSummary(this)
    }
}
