// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to an Amazon VPC.
 */
class DataSourceVpcConfiguration private constructor(builder: Builder) {
    /**
     * A list of identifiers of security groups within your Amazon VPC.
     * The security groups should enable Amazon Kendra to connect to the data
     * source.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of identifiers for subnets within your Amazon VPC. The
     * subnets should be able to connect to each other in the VPC, and they
     * should have outgoing access to the Internet through a NAT
     * device.
     */
    val subnetIds: List<String>? = builder.subnetIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceVpcConfiguration(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceVpcConfiguration

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of identifiers of security groups within your Amazon VPC.
         * The security groups should enable Amazon Kendra to connect to the data
         * source.
         */
        var securityGroupIds: List<String>? = null
        /**
         * A list of identifiers for subnets within your Amazon VPC. The
         * subnets should be able to connect to each other in the VPC, and they
         * should have outgoing access to the Internet through a NAT
         * device.
         */
        var subnetIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration = DataSourceVpcConfiguration(this)
    }
}
