// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * The target document attribute or metadata field you want to alter when ingesting
 * documents into Amazon Kendra.
 * For example, you can delete customer identification numbers associated with the
 * documents, stored in the document metadata field called 'Customer_ID'. You set the
 * target key as 'Customer_ID' and the deletion flag to TRUE. This
 * removes all customer ID values in the field 'Customer_ID'. This would scrub
 * personally identifiable information from each document's metadata.
 * Amazon Kendra cannot create a target field if it has not already been created as an
 * index field. After you create your index field, you can create a document metadata
 * field using DocumentAttributeTarget. Amazon Kendra then will map your newly
 * created metadata field to your index field.
 * You can also use this with <a href="https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html">DocumentAttributeCondition.
 */
class DocumentAttributeTarget private constructor(builder: Builder) {
    /**
     * The identifier of the target document attribute or metadata field.
     * For example, 'Department' could be an identifier for the target attribute or
     * metadata field that includes the department names associated with the documents.
     */
    val targetDocumentAttributeKey: kotlin.String? = builder.targetDocumentAttributeKey
    /**
     * The target value you want to create for the target attribute.
     * For example, 'Finance' could be the target value for the target attribute key
     * 'Department'.
     */
    val targetDocumentAttributeValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = builder.targetDocumentAttributeValue
    /**
     * TRUE to delete the existing target value for your specified target
     * attribute key. You cannot create a target value and set this to TRUE.
     * To create a target value (TargetDocumentAttributeValue), set this to
     * FALSE.
     */
    val targetDocumentAttributeValueDeletion: kotlin.Boolean = builder.targetDocumentAttributeValueDeletion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentAttributeTarget(")
        append("targetDocumentAttributeKey=$targetDocumentAttributeKey,")
        append("targetDocumentAttributeValue=$targetDocumentAttributeValue,")
        append("targetDocumentAttributeValueDeletion=$targetDocumentAttributeValueDeletion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = targetDocumentAttributeKey?.hashCode() ?: 0
        result = 31 * result + (targetDocumentAttributeValue?.hashCode() ?: 0)
        result = 31 * result + (targetDocumentAttributeValueDeletion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentAttributeTarget

        if (targetDocumentAttributeKey != other.targetDocumentAttributeKey) return false
        if (targetDocumentAttributeValue != other.targetDocumentAttributeValue) return false
        if (targetDocumentAttributeValueDeletion != other.targetDocumentAttributeValueDeletion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the target document attribute or metadata field.
         * For example, 'Department' could be an identifier for the target attribute or
         * metadata field that includes the department names associated with the documents.
         */
        var targetDocumentAttributeKey: kotlin.String? = null
        /**
         * The target value you want to create for the target attribute.
         * For example, 'Finance' could be the target value for the target attribute key
         * 'Department'.
         */
        var targetDocumentAttributeValue: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue? = null
        /**
         * TRUE to delete the existing target value for your specified target
         * attribute key. You cannot create a target value and set this to TRUE.
         * To create a target value (TargetDocumentAttributeValue), set this to
         * FALSE.
         */
        var targetDocumentAttributeValueDeletion: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget) : this() {
            this.targetDocumentAttributeKey = x.targetDocumentAttributeKey
            this.targetDocumentAttributeValue = x.targetDocumentAttributeValue
            this.targetDocumentAttributeValueDeletion = x.targetDocumentAttributeValueDeletion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DocumentAttributeTarget = DocumentAttributeTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue] inside the given [block]
         */
        fun targetDocumentAttributeValue(block: aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.Builder.() -> kotlin.Unit) {
            this.targetDocumentAttributeValue = aws.sdk.kotlin.services.kendra.model.DocumentAttributeValue.invoke(block)
        }
    }
}
