// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for your Amazon Kendra experience. This includes
 * the data source IDs and/or FAQ IDs, and user or group information to grant access
 * to your Amazon Kendra experience.
 */
class ExperienceConfiguration private constructor(builder: Builder) {
    /**
     * The identifiers of your data sources and FAQs. Or, you can specify
     * that you want to use documents indexed via the BatchPutDocument
     * API. This is the content you want to use for your Amazon Kendra experience.
     */
    val contentSourceConfiguration: aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration? = builder.contentSourceConfiguration
    /**
     * The Amazon Web Services SSO field name that contains the identifiers of your users,
     * such as their emails.
     */
    val userIdentityConfiguration: aws.sdk.kotlin.services.kendra.model.UserIdentityConfiguration? = builder.userIdentityConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExperienceConfiguration(")
        append("contentSourceConfiguration=$contentSourceConfiguration,")
        append("userIdentityConfiguration=$userIdentityConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentSourceConfiguration?.hashCode() ?: 0
        result = 31 * result + (userIdentityConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExperienceConfiguration

        if (contentSourceConfiguration != other.contentSourceConfiguration) return false
        if (userIdentityConfiguration != other.userIdentityConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifiers of your data sources and FAQs. Or, you can specify
         * that you want to use documents indexed via the BatchPutDocument
         * API. This is the content you want to use for your Amazon Kendra experience.
         */
        var contentSourceConfiguration: aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration? = null
        /**
         * The Amazon Web Services SSO field name that contains the identifiers of your users,
         * such as their emails.
         */
        var userIdentityConfiguration: aws.sdk.kotlin.services.kendra.model.UserIdentityConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration) : this() {
            this.contentSourceConfiguration = x.contentSourceConfiguration
            this.userIdentityConfiguration = x.userIdentityConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration = ExperienceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration] inside the given [block]
         */
        fun contentSourceConfiguration(block: aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.contentSourceConfiguration = aws.sdk.kotlin.services.kendra.model.ContentSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserIdentityConfiguration] inside the given [block]
         */
        fun userIdentityConfiguration(block: aws.sdk.kotlin.services.kendra.model.UserIdentityConfiguration.Builder.() -> kotlin.Unit) {
            this.userIdentityConfiguration = aws.sdk.kotlin.services.kendra.model.UserIdentityConfiguration.invoke(block)
        }
    }
}
