// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Amazon FSx as
 * your data source.
 */
class FsxConfiguration private constructor(builder: Builder) {
    /**
     * A list of regular expression patterns to exclude certain files
     * in your Amazon FSx file system. Files that match the patterns
     * are excluded from the index. Files that don't match the patterns are
     * included in the index. If a file matches both an inclusion and exclusion
     * pattern, the exclusion pattern takes precedence and the file isn't included
     * in the index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of DataSourceToIndexFieldMapping objects that
     * map Amazon FSx data source attributes or field names to Amazon Kendra
     * index field names. To create custom fields, use the
     * UpdateIndex API before you map to Amazon FSx fields.
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
     * data source fields. The Amazon FSx data source field names
     * must exist in your Amazon FSx custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * The identifier of the Amazon FSx file system.
     * You can find your file system ID on the file system dashboard in
     * the Amazon FSx console. For information on how to create a
     * file system in Amazon FSx console, using Windows File Server
     * as an example, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/getting-started-step1.html">Amazon FSx
     * Getting started guide.
     */
    val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The Amazon FSx file system type. Windows is currently the only
     * supported type.
     */
    val fileSystemType: aws.sdk.kotlin.services.kendra.model.FsxFileSystemType? = builder.fileSystemType
    /**
     * A list of regular expression patterns to include certain files
     * in your Amazon FSx file system. Files that match the patterns
     * are included in the index. Files that don't match the patterns are
     * excluded from the index. If a file matches both an inclusion and
     * exclusion pattern, the exclusion pattern takes precedence and the file
     * isn't included in the index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that
     * contains the key-value pairs required to connect to your Amazon FSx
     * file system. Windows is currently the only supported type. The secret must
     * contain a JSON structure with the following keys:
     *
     *
     * username—The Active Directory user name, along with the
     * Domain Name System (DNS) domain name. For example,
     * user@corp.example.com. The Active Directory
     * user account must have read and mounting access to the
     * Amazon FSx file system for Windows.
     *
     * password—The password of the Active Directory user account with
     * read and mounting access to the Amazon FSx Windows file system.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect
     * to your Amazon FSx. Your Amazon FSx
     * instance must reside inside your VPC.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FsxConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FsxConfiguration(")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemType=$fileSystemType,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("secretArn=$secretArn,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusionPatterns?.hashCode() ?: 0
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (fileSystemType?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FsxConfiguration

        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemType != other.fileSystemType) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (secretArn != other.secretArn) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FsxConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of regular expression patterns to exclude certain files
         * in your Amazon FSx file system. Files that match the patterns
         * are excluded from the index. Files that don't match the patterns are
         * included in the index. If a file matches both an inclusion and exclusion
         * pattern, the exclusion pattern takes precedence and the file isn't included
         * in the index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that
         * map Amazon FSx data source attributes or field names to Amazon Kendra
         * index field names. To create custom fields, use the
         * UpdateIndex API before you map to Amazon FSx fields.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         * data source fields. The Amazon FSx data source field names
         * must exist in your Amazon FSx custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The identifier of the Amazon FSx file system.
         * You can find your file system ID on the file system dashboard in
         * the Amazon FSx console. For information on how to create a
         * file system in Amazon FSx console, using Windows File Server
         * as an example, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/getting-started-step1.html">Amazon FSx
         * Getting started guide.
         */
        var fileSystemId: kotlin.String? = null
        /**
         * The Amazon FSx file system type. Windows is currently the only
         * supported type.
         */
        var fileSystemType: aws.sdk.kotlin.services.kendra.model.FsxFileSystemType? = null
        /**
         * A list of regular expression patterns to include certain files
         * in your Amazon FSx file system. Files that match the patterns
         * are included in the index. Files that don't match the patterns are
         * excluded from the index. If a file matches both an inclusion and
         * exclusion pattern, the exclusion pattern takes precedence and the file
         * isn't included in the index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that
         * contains the key-value pairs required to connect to your Amazon FSx
         * file system. Windows is currently the only supported type. The secret must
         * contain a JSON structure with the following keys:
         *
         *
         * username—The Active Directory user name, along with the
         * Domain Name System (DNS) domain name. For example,
         * user@corp.example.com. The Active Directory
         * user account must have read and mounting access to the
         * Amazon FSx file system for Windows.
         *
         * password—The password of the Active Directory user account with
         * read and mounting access to the Amazon FSx Windows file system.
         */
        var secretArn: kotlin.String? = null
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect
         * to your Amazon FSx. Your Amazon FSx
         * instance must reside inside your VPC.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FsxConfiguration) : this() {
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.fileSystemId = x.fileSystemId
            this.fileSystemType = x.fileSystemType
            this.inclusionPatterns = x.inclusionPatterns
            this.secretArn = x.secretArn
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FsxConfiguration = FsxConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
