// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * A list of users or sub groups that belong to a group. Users and groups
 * are useful for filtering search results to different users based on their
 * group's access to documents.
 */
class GroupMembers private constructor(builder: Builder) {
    /**
     * A list of sub groups that belong to a group. For example, the sub
     * groups "Research", "Engineering", and "Sales and Marketing" all belong
     * to the group "Company".
     */
    val memberGroups: List<MemberGroup>? = builder.memberGroups
    /**
     * A list of users that belong to a group. For example, a list of interns
     * all belong to the "Interns" group.
     */
    val memberUsers: List<MemberUser>? = builder.memberUsers
    /**
     * If you have more than 1000 users and/or sub groups for a single group,
     * you need to provide the path to the S3 file that lists your users and sub
     * groups for a group. Your sub groups can contain more than 1000 users, but
     * the list of sub groups that belong to a group (and/or users) must be no
     * more than 1000.
     * You can download this
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
     * S3 file that uses the correct format for listing group members. Note,
     * dataSourceId is optional. The value of type
     * for a group is always GROUP and for a user it is
     * always USER.
     */
    val s3PathforGroupMembers: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.s3PathforGroupMembers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.GroupMembers = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupMembers(")
        append("memberGroups=$memberGroups,")
        append("memberUsers=$memberUsers,")
        append("s3PathforGroupMembers=$s3PathforGroupMembers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = memberGroups?.hashCode() ?: 0
        result = 31 * result + (memberUsers?.hashCode() ?: 0)
        result = 31 * result + (s3PathforGroupMembers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupMembers

        if (memberGroups != other.memberGroups) return false
        if (memberUsers != other.memberUsers) return false
        if (s3PathforGroupMembers != other.s3PathforGroupMembers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.GroupMembers = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of sub groups that belong to a group. For example, the sub
         * groups "Research", "Engineering", and "Sales and Marketing" all belong
         * to the group "Company".
         */
        var memberGroups: List<MemberGroup>? = null
        /**
         * A list of users that belong to a group. For example, a list of interns
         * all belong to the "Interns" group.
         */
        var memberUsers: List<MemberUser>? = null
        /**
         * If you have more than 1000 users and/or sub groups for a single group,
         * you need to provide the path to the S3 file that lists your users and sub
         * groups for a group. Your sub groups can contain more than 1000 users, but
         * the list of sub groups that belong to a group (and/or users) must be no
         * more than 1000.
         * You can download this
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip">example
         * S3 file that uses the correct format for listing group members. Note,
         * dataSourceId is optional. The value of type
         * for a group is always GROUP and for a user it is
         * always USER.
         */
        var s3PathforGroupMembers: aws.sdk.kotlin.services.kendra.model.S3Path? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.GroupMembers) : this() {
            this.memberGroups = x.memberGroups
            this.memberUsers = x.memberUsers
            this.s3PathforGroupMembers = x.s3PathforGroupMembers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.GroupMembers = GroupMembers(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        fun s3PathforGroupMembers(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.s3PathforGroupMembers = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }
    }
}
