// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information on the processing of PUT and DELETE actions
 * for mapping users to their groups.
 */
class GroupOrderingIdSummary private constructor(builder: Builder) {
    /**
     * The reason an action could not be processed. An action can be a
     * PUT or DELETE action for mapping users
     * to their groups.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * The last date-time an action was updated. An action can be a
     * PUT or DELETE action for mapping users
     * to their groups.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The order in which actions should complete processing. An action can
     * be a PUT or DELETE action for mapping users
     * to their groups.
     */
    val orderingId: kotlin.Long? = builder.orderingId
    /**
     * The date-time an action was received by Amazon Kendra. An action can be a
     * PUT or DELETE action for mapping users to
     * their groups.
     */
    val receivedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.receivedAt
    /**
     * The current processing status of actions for mapping users to their groups.
     * The status can be either PROCESSING, SUCCEEDED,
     * DELETING, DELETED, or FAILED.
     */
    val status: aws.sdk.kotlin.services.kendra.model.PrincipalMappingStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupOrderingIdSummary(")
        append("failureReason=$failureReason,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("orderingId=$orderingId,")
        append("receivedAt=$receivedAt,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureReason?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (orderingId?.hashCode() ?: 0)
        result = 31 * result + (receivedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupOrderingIdSummary

        if (failureReason != other.failureReason) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (orderingId != other.orderingId) return false
        if (receivedAt != other.receivedAt) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The reason an action could not be processed. An action can be a
         * PUT or DELETE action for mapping users
         * to their groups.
         */
        var failureReason: kotlin.String? = null
        /**
         * The last date-time an action was updated. An action can be a
         * PUT or DELETE action for mapping users
         * to their groups.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The order in which actions should complete processing. An action can
         * be a PUT or DELETE action for mapping users
         * to their groups.
         */
        var orderingId: kotlin.Long? = null
        /**
         * The date-time an action was received by Amazon Kendra. An action can be a
         * PUT or DELETE action for mapping users to
         * their groups.
         */
        var receivedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current processing status of actions for mapping users to their groups.
         * The status can be either PROCESSING, SUCCEEDED,
         * DELETING, DELETED, or FAILED.
         */
        var status: aws.sdk.kotlin.services.kendra.model.PrincipalMappingStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary) : this() {
            this.failureReason = x.failureReason
            this.lastUpdatedAt = x.lastUpdatedAt
            this.orderingId = x.orderingId
            this.receivedAt = x.receivedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.GroupOrderingIdSummary = GroupOrderingIdSummary(this)
    }
}
