// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information on the configuration of an index.
 */
class IndexConfigurationSummary private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the index was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Indicates whether the index is a enterprise edition index or a
     * developer edition index.
     */
    val edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = builder.edition
    /**
     * A unique identifier for the index. Use this to identify the index
     * when you are using APIs such as Query,
     * DescribeIndex, UpdateIndex, and
     * DeleteIndex.
     */
    val id: kotlin.String? = builder.id
    /**
     * The identifier of the index.
     */
    val name: kotlin.String? = builder.name
    /**
     * The current status of the index. When the status is
     * ACTIVE, the index is ready to search.
     */
    val status: aws.sdk.kotlin.services.kendra.model.IndexStatus? = builder.status
    /**
     * The Unix timestamp when the index was last updated by the
     * UpdateIndex API.
     */
    val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndexConfigurationSummary(")
        append("createdAt=$createdAt,")
        append("edition=$edition,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndexConfigurationSummary

        if (createdAt != other.createdAt) return false
        if (edition != other.edition) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Unix timestamp when the index was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the index is a enterprise edition index or a
         * developer edition index.
         */
        var edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = null
        /**
         * A unique identifier for the index. Use this to identify the index
         * when you are using APIs such as Query,
         * DescribeIndex, UpdateIndex, and
         * DeleteIndex.
         */
        var id: kotlin.String? = null
        /**
         * The identifier of the index.
         */
        var name: kotlin.String? = null
        /**
         * The current status of the index. When the status is
         * ACTIVE, the index is ready to search.
         */
        var status: aws.sdk.kotlin.services.kendra.model.IndexStatus? = null
        /**
         * The Unix timestamp when the index was last updated by the
         * UpdateIndex API.
         */
        var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary) : this() {
            this.createdAt = x.createdAt
            this.edition = x.edition
            this.id = x.id
            this.name = x.name
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.IndexConfigurationSummary = IndexConfigurationSummary(this)
    }
}
