// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



class QueryResponse private constructor(builder: Builder) {
    /**
     * Contains the facet results. A FacetResult contains the
     * counts for each attribute key that was specified in the
     * Facets input parameter.
     */
    val facetResults: List<FacetResult>? = builder.facetResults
    /**
     * The unique identifier for the search. You use QueryId
     * to identify the search when using the feedback API.
     */
    val queryId: kotlin.String? = builder.queryId
    /**
     * The results of the search.
     */
    val resultItems: List<QueryResultItem>? = builder.resultItems
    /**
     * A list of information related to suggested spell corrections for a query.
     */
    val spellCorrectedQueries: List<SpellCorrectedQuery>? = builder.spellCorrectedQueries
    /**
     * The total number of items found by the search; however, you can only
     * retrieve up to 100 items. For example, if the search found 192 items,
     * you can only retrieve the first 100 of the items.
     */
    val totalNumberOfResults: kotlin.Int? = builder.totalNumberOfResults
    /**
     * A list of warning codes and their messages on problems with your query.
     * Amazon Kendra currently only supports one type of warning, which is a warning
     * on invalid syntax used in the query. For examples of invalid query syntax,
     * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching
     * with advanced query syntax.
     */
    val warnings: List<Warning>? = builder.warnings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResponse(")
        append("facetResults=$facetResults,")
        append("queryId=$queryId,")
        append("resultItems=$resultItems,")
        append("spellCorrectedQueries=$spellCorrectedQueries,")
        append("totalNumberOfResults=$totalNumberOfResults,")
        append("warnings=$warnings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = facetResults?.hashCode() ?: 0
        result = 31 * result + (queryId?.hashCode() ?: 0)
        result = 31 * result + (resultItems?.hashCode() ?: 0)
        result = 31 * result + (spellCorrectedQueries?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfResults ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResponse

        if (facetResults != other.facetResults) return false
        if (queryId != other.queryId) return false
        if (resultItems != other.resultItems) return false
        if (spellCorrectedQueries != other.spellCorrectedQueries) return false
        if (totalNumberOfResults != other.totalNumberOfResults) return false
        if (warnings != other.warnings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains the facet results. A FacetResult contains the
         * counts for each attribute key that was specified in the
         * Facets input parameter.
         */
        var facetResults: List<FacetResult>? = null
        /**
         * The unique identifier for the search. You use QueryId
         * to identify the search when using the feedback API.
         */
        var queryId: kotlin.String? = null
        /**
         * The results of the search.
         */
        var resultItems: List<QueryResultItem>? = null
        /**
         * A list of information related to suggested spell corrections for a query.
         */
        var spellCorrectedQueries: List<SpellCorrectedQuery>? = null
        /**
         * The total number of items found by the search; however, you can only
         * retrieve up to 100 items. For example, if the search found 192 items,
         * you can only retrieve the first 100 of the items.
         */
        var totalNumberOfResults: kotlin.Int? = null
        /**
         * A list of warning codes and their messages on problems with your query.
         * Amazon Kendra currently only supports one type of warning, which is a warning
         * on invalid syntax used in the query. For examples of invalid query syntax,
         * see <a href="https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax">Searching
         * with advanced query syntax.
         */
        var warnings: List<Warning>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryResponse) : this() {
            this.facetResults = x.facetResults
            this.queryId = x.queryId
            this.resultItems = x.resultItems
            this.spellCorrectedQueries = x.spellCorrectedQueries
            this.totalNumberOfResults = x.totalNumberOfResults
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryResponse = QueryResponse(this)
    }
}
