// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * A single query result.
 * A query result contains information about a document returned by the
 * query. This includes the original location of the document, a list of
 * attributes assigned to the document, and relevant text from the
 * document that satisfies the query.
 */
class QueryResultItem private constructor(builder: Builder) {
    /**
     * One or more additional attributes associated with the query
     * result.
     */
    val additionalAttributes: List<AdditionalResultAttribute>? = builder.additionalAttributes
    /**
     * An array of document attributes for the document that the query
     * result maps to. For example, the document author (Author) or the source
     * URI (SourceUri) of the document.
     */
    val documentAttributes: List<DocumentAttribute>? = builder.documentAttributes
    /**
     * An extract of the text in the document. Contains information about
     * highlighting the relevant terms in the excerpt.
     */
    val documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentExcerpt
    /**
     * The unique identifier for the document.
     */
    val documentId: kotlin.String? = builder.documentId
    /**
     * The title of the document. Contains the text of the title and
     * information for highlighting the relevant terms in the title.
     */
    val documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentTitle
    /**
     * The URI of the original location of the document.
     */
    val documentUri: kotlin.String? = builder.documentUri
    /**
     * A token that identifies a particular result from a particular query.
     * Use this token to provide click-through feedback for the result. For
     * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
     * .
     */
    val feedbackToken: kotlin.String? = builder.feedbackToken
    /**
     * The unique identifier for the query result.
     */
    val id: kotlin.String? = builder.id
    /**
     * Indicates the confidence that Amazon Kendra has that a result matches the
     * query that you provided. Each result is placed into a bin that
     * indicates the confidence, VERY_HIGH, HIGH,
     * MEDIUM and LOW. You can use the score to
     * determine if a response meets the confidence needed for your
     * application.
     * The field is only set to LOW when the Type
     * field is set to DOCUMENT and Amazon Kendra is not confident that
     * the result matches the query.
     */
    val scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = builder.scoreAttributes
    /**
     * The type of document.
     */
    val type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResultItem(")
        append("additionalAttributes=$additionalAttributes,")
        append("documentAttributes=$documentAttributes,")
        append("documentExcerpt=$documentExcerpt,")
        append("documentId=$documentId,")
        append("documentTitle=$documentTitle,")
        append("documentUri=$documentUri,")
        append("feedbackToken=$feedbackToken,")
        append("id=$id,")
        append("scoreAttributes=$scoreAttributes,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (documentAttributes?.hashCode() ?: 0)
        result = 31 * result + (documentExcerpt?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (documentTitle?.hashCode() ?: 0)
        result = 31 * result + (documentUri?.hashCode() ?: 0)
        result = 31 * result + (feedbackToken?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (scoreAttributes?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResultItem

        if (additionalAttributes != other.additionalAttributes) return false
        if (documentAttributes != other.documentAttributes) return false
        if (documentExcerpt != other.documentExcerpt) return false
        if (documentId != other.documentId) return false
        if (documentTitle != other.documentTitle) return false
        if (documentUri != other.documentUri) return false
        if (feedbackToken != other.feedbackToken) return false
        if (id != other.id) return false
        if (scoreAttributes != other.scoreAttributes) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryResultItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * One or more additional attributes associated with the query
         * result.
         */
        var additionalAttributes: List<AdditionalResultAttribute>? = null
        /**
         * An array of document attributes for the document that the query
         * result maps to. For example, the document author (Author) or the source
         * URI (SourceUri) of the document.
         */
        var documentAttributes: List<DocumentAttribute>? = null
        /**
         * An extract of the text in the document. Contains information about
         * highlighting the relevant terms in the excerpt.
         */
        var documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The unique identifier for the document.
         */
        var documentId: kotlin.String? = null
        /**
         * The title of the document. Contains the text of the title and
         * information for highlighting the relevant terms in the title.
         */
        var documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The URI of the original location of the document.
         */
        var documentUri: kotlin.String? = null
        /**
         * A token that identifies a particular result from a particular query.
         * Use this token to provide click-through feedback for the result. For
         * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html"> Submitting feedback
         * .
         */
        var feedbackToken: kotlin.String? = null
        /**
         * The unique identifier for the query result.
         */
        var id: kotlin.String? = null
        /**
         * Indicates the confidence that Amazon Kendra has that a result matches the
         * query that you provided. Each result is placed into a bin that
         * indicates the confidence, VERY_HIGH, HIGH,
         * MEDIUM and LOW. You can use the score to
         * determine if a response meets the confidence needed for your
         * application.
         * The field is only set to LOW when the Type
         * field is set to DOCUMENT and Amazon Kendra is not confident that
         * the result matches the query.
         */
        var scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = null
        /**
         * The type of document.
         */
        var type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryResultItem) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.documentAttributes = x.documentAttributes
            this.documentExcerpt = x.documentExcerpt
            this.documentId = x.documentId
            this.documentTitle = x.documentTitle
            this.documentUri = x.documentUri
            this.feedbackToken = x.feedbackToken
            this.id = x.id
            this.scoreAttributes = x.scoreAttributes
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryResultItem = QueryResultItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        fun documentExcerpt(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentExcerpt = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        fun documentTitle(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentTitle = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ScoreAttributes] inside the given [block]
         */
        fun scoreAttributes(block: aws.sdk.kotlin.services.kendra.model.ScoreAttributes.Builder.() -> kotlin.Unit) {
            this.scoreAttributes = aws.sdk.kotlin.services.kendra.model.ScoreAttributes.invoke(block)
        }
    }
}
