// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to
 * an Amazon S3 bucket.
 */
class S3DataSourceConfiguration private constructor(builder: Builder) {
    /**
     * Provides the path to the S3 bucket that contains the user context
     * filtering files for the data source. For the format of the file, see
     * <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources.
     */
    val accessControlListConfiguration: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration? = builder.accessControlListConfiguration
    /**
     * The name of the bucket that contains the documents.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * Document metadata files that contain information such as the
     * document access control information, source URI, document author,
     * and custom attributes. Each metadata file contains metadata about a
     * single document.
     */
    val documentsMetadataConfiguration: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration? = builder.documentsMetadataConfiguration
    /**
     * A list of glob patterns for documents that should not be indexed.
     * If a document that matches an inclusion prefix or inclusion pattern
     * also matches an exclusion pattern, the document is not
     * indexed.
     * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples
     * are:
     *
     *
     *
     * *.png , *.jpg will exclude
     * all PNG and JPEG image files in a directory
     * (files with the extensions .png and .jpg).
     *
     *
     * *internal* will exclude all
     * files in a directory that contain 'internal' in the file name,
     * such as 'internal', 'internal_only', 'company_internal'.
     *
     *
     * **&#47;*internal* will exclude
     * all internal-related files in a directory and its subdirectories.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of glob patterns for documents that should be indexed. If a
     * document that matches an inclusion pattern also matches an exclusion
     * pattern, the document is not indexed.
     * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples
     * are:
     *
     *
     *
     * *.txt will include all text files
     * in a directory (files with the extension .txt).
     *
     *
     * **&#47;*.txt will include all text
     * files in a directory and its subdirectories.
     *
     *
     * *tax* will include all files in
     * a directory that contain 'tax' in the file name, such as 'tax',
     * 'taxes', 'income_tax'.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * A list of S3 prefixes for the documents that should be included in
     * the index.
     */
    val inclusionPrefixes: List<String>? = builder.inclusionPrefixes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DataSourceConfiguration(")
        append("accessControlListConfiguration=$accessControlListConfiguration,")
        append("bucketName=$bucketName,")
        append("documentsMetadataConfiguration=$documentsMetadataConfiguration,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("inclusionPrefixes=$inclusionPrefixes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlListConfiguration?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (documentsMetadataConfiguration?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPrefixes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DataSourceConfiguration

        if (accessControlListConfiguration != other.accessControlListConfiguration) return false
        if (bucketName != other.bucketName) return false
        if (documentsMetadataConfiguration != other.documentsMetadataConfiguration) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (inclusionPrefixes != other.inclusionPrefixes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides the path to the S3 bucket that contains the user context
         * filtering files for the data source. For the format of the file, see
         * <a href="https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html">Access control for S3 data sources.
         */
        var accessControlListConfiguration: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration? = null
        /**
         * The name of the bucket that contains the documents.
         */
        var bucketName: kotlin.String? = null
        /**
         * Document metadata files that contain information such as the
         * document access control information, source URI, document author,
         * and custom attributes. Each metadata file contains metadata about a
         * single document.
         */
        var documentsMetadataConfiguration: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration? = null
        /**
         * A list of glob patterns for documents that should not be indexed.
         * If a document that matches an inclusion prefix or inclusion pattern
         * also matches an exclusion pattern, the document is not
         * indexed.
         * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples
         * are:
         *
         *
         *
         * *.png , *.jpg will exclude
         * all PNG and JPEG image files in a directory
         * (files with the extensions .png and .jpg).
         *
         *
         * *internal* will exclude all
         * files in a directory that contain 'internal' in the file name,
         * such as 'internal', 'internal_only', 'company_internal'.
         *
         *
         * **&#47;*internal* will exclude
         * all internal-related files in a directory and its subdirectories.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of glob patterns for documents that should be indexed. If a
         * document that matches an inclusion pattern also matches an exclusion
         * pattern, the document is not indexed.
         * Some <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters">examples
         * are:
         *
         *
         *
         * *.txt will include all text files
         * in a directory (files with the extension .txt).
         *
         *
         * **&#47;*.txt will include all text
         * files in a directory and its subdirectories.
         *
         *
         * *tax* will include all files in
         * a directory that contain 'tax' in the file name, such as 'tax',
         * 'taxes', 'income_tax'.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * A list of S3 prefixes for the documents that should be included in
         * the index.
         */
        var inclusionPrefixes: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration) : this() {
            this.accessControlListConfiguration = x.accessControlListConfiguration
            this.bucketName = x.bucketName
            this.documentsMetadataConfiguration = x.documentsMetadataConfiguration
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.inclusionPrefixes = x.inclusionPrefixes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.S3DataSourceConfiguration = S3DataSourceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration] inside the given [block]
         */
        fun accessControlListConfiguration(block: aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration.Builder.() -> kotlin.Unit) {
            this.accessControlListConfiguration = aws.sdk.kotlin.services.kendra.model.AccessControlListConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration] inside the given [block]
         */
        fun documentsMetadataConfiguration(block: aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration.Builder.() -> kotlin.Unit) {
            this.documentsMetadataConfiguration = aws.sdk.kotlin.services.kendra.model.DocumentsMetadataConfiguration.invoke(block)
        }
    }
}
