// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Salesforce
 * as your data source.
 */
class SalesforceConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information for Salesforce chatter feeds.
     */
    val chatterFeedConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration? = builder.chatterFeedConfiguration
    /**
     * Indicates whether Amazon Kendra should index attachments to Salesforce
     * objects.
     */
    val crawlAttachments: kotlin.Boolean = builder.crawlAttachments
    /**
     * A list of regular expression patterns to exclude certain documents in your Salesforce.
     * Documents that match the patterns are excluded from the index. Documents that
     * don't match the patterns are included in the index. If a document matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * document isn't included in the index.
     * The pattern is applied to the name of the attached file.
     */
    val excludeAttachmentFilePatterns: List<String>? = builder.excludeAttachmentFilePatterns
    /**
     * A list of regular expression patterns to include certain documents in your Salesforce.
     * Documents that match the patterns are included in the index. Documents that
     * don't match the patterns are excluded from the index. If a document matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * document isn't included in the index.
     * The pattern is applied to the name of the attached file.
     */
    val includeAttachmentFilePatterns: List<String>? = builder.includeAttachmentFilePatterns
    /**
     * Configuration information for the knowledge article
     * types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
     * articles and the standard fields of knowledge articles, or the
     * custom fields of custom knowledge articles, but not both.
     */
    val knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceKnowledgeArticleConfiguration? = builder.knowledgeArticleConfiguration
    /**
     * The Amazon Resource Name (ARN) of an Secrets Managersecret
     * that contains the key/value pairs required to connect to your
     * Salesforce instance. The secret must contain a JSON structure with
     * the following keys:
     *
     *
     * authenticationUrl - The OAUTH endpoint that Amazon Kendra
     * connects to get an OAUTH token.
     *
     * consumerKey - The application public key generated when
     * you created your Salesforce application.
     *
     * consumerSecret - The application private key generated
     * when you created your Salesforce application.
     *
     * password - The password associated with the user logging
     * in to the Salesforce instance.
     *
     * securityToken - The token associated with the user account
     * logging in to the Salesforce instance.
     *
     * username - The user name of the user logging in to the
     * Salesforce instance.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The instance URL for the Salesforce site that you want to
     * index.
     */
    val serverUrl: kotlin.String? = builder.serverUrl
    /**
     * Configuration information for processing attachments to
     * Salesforce standard objects.
     */
    val standardObjectAttachmentConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration? = builder.standardObjectAttachmentConfiguration
    /**
     * Configuration of the Salesforce standard objects that Amazon Kendra
     * indexes.
     */
    val standardObjectConfigurations: List<SalesforceStandardObjectConfiguration>? = builder.standardObjectConfigurations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceConfiguration(")
        append("chatterFeedConfiguration=$chatterFeedConfiguration,")
        append("crawlAttachments=$crawlAttachments,")
        append("excludeAttachmentFilePatterns=$excludeAttachmentFilePatterns,")
        append("includeAttachmentFilePatterns=$includeAttachmentFilePatterns,")
        append("knowledgeArticleConfiguration=$knowledgeArticleConfiguration,")
        append("secretArn=$secretArn,")
        append("serverUrl=$serverUrl,")
        append("standardObjectAttachmentConfiguration=$standardObjectAttachmentConfiguration,")
        append("standardObjectConfigurations=$standardObjectConfigurations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = chatterFeedConfiguration?.hashCode() ?: 0
        result = 31 * result + (crawlAttachments.hashCode())
        result = 31 * result + (excludeAttachmentFilePatterns?.hashCode() ?: 0)
        result = 31 * result + (includeAttachmentFilePatterns?.hashCode() ?: 0)
        result = 31 * result + (knowledgeArticleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (serverUrl?.hashCode() ?: 0)
        result = 31 * result + (standardObjectAttachmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (standardObjectConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceConfiguration

        if (chatterFeedConfiguration != other.chatterFeedConfiguration) return false
        if (crawlAttachments != other.crawlAttachments) return false
        if (excludeAttachmentFilePatterns != other.excludeAttachmentFilePatterns) return false
        if (includeAttachmentFilePatterns != other.includeAttachmentFilePatterns) return false
        if (knowledgeArticleConfiguration != other.knowledgeArticleConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (serverUrl != other.serverUrl) return false
        if (standardObjectAttachmentConfiguration != other.standardObjectAttachmentConfiguration) return false
        if (standardObjectConfigurations != other.standardObjectConfigurations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration information for Salesforce chatter feeds.
         */
        var chatterFeedConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration? = null
        /**
         * Indicates whether Amazon Kendra should index attachments to Salesforce
         * objects.
         */
        var crawlAttachments: kotlin.Boolean = false
        /**
         * A list of regular expression patterns to exclude certain documents in your Salesforce.
         * Documents that match the patterns are excluded from the index. Documents that
         * don't match the patterns are included in the index. If a document matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * The pattern is applied to the name of the attached file.
         */
        var excludeAttachmentFilePatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain documents in your Salesforce.
         * Documents that match the patterns are included in the index. Documents that
         * don't match the patterns are excluded from the index. If a document matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * The pattern is applied to the name of the attached file.
         */
        var includeAttachmentFilePatterns: List<String>? = null
        /**
         * Configuration information for the knowledge article
         * types that Amazon Kendra indexes. Amazon Kendra indexes standard knowledge
         * articles and the standard fields of knowledge articles, or the
         * custom fields of custom knowledge articles, but not both.
         */
        var knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceKnowledgeArticleConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Managersecret
         * that contains the key/value pairs required to connect to your
         * Salesforce instance. The secret must contain a JSON structure with
         * the following keys:
         *
         *
         * authenticationUrl - The OAUTH endpoint that Amazon Kendra
         * connects to get an OAUTH token.
         *
         * consumerKey - The application public key generated when
         * you created your Salesforce application.
         *
         * consumerSecret - The application private key generated
         * when you created your Salesforce application.
         *
         * password - The password associated with the user logging
         * in to the Salesforce instance.
         *
         * securityToken - The token associated with the user account
         * logging in to the Salesforce instance.
         *
         * username - The user name of the user logging in to the
         * Salesforce instance.
         */
        var secretArn: kotlin.String? = null
        /**
         * The instance URL for the Salesforce site that you want to
         * index.
         */
        var serverUrl: kotlin.String? = null
        /**
         * Configuration information for processing attachments to
         * Salesforce standard objects.
         */
        var standardObjectAttachmentConfiguration: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration? = null
        /**
         * Configuration of the Salesforce standard objects that Amazon Kendra
         * indexes.
         */
        var standardObjectConfigurations: List<SalesforceStandardObjectConfiguration>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration) : this() {
            this.chatterFeedConfiguration = x.chatterFeedConfiguration
            this.crawlAttachments = x.crawlAttachments
            this.excludeAttachmentFilePatterns = x.excludeAttachmentFilePatterns
            this.includeAttachmentFilePatterns = x.includeAttachmentFilePatterns
            this.knowledgeArticleConfiguration = x.knowledgeArticleConfiguration
            this.secretArn = x.secretArn
            this.serverUrl = x.serverUrl
            this.standardObjectAttachmentConfiguration = x.standardObjectAttachmentConfiguration
            this.standardObjectConfigurations = x.standardObjectConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SalesforceConfiguration = SalesforceConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration] inside the given [block]
         */
        fun chatterFeedConfiguration(block: aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration.Builder.() -> kotlin.Unit) {
            this.chatterFeedConfiguration = aws.sdk.kotlin.services.kendra.model.SalesforceChatterFeedConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SalesforceKnowledgeArticleConfiguration] inside the given [block]
         */
        fun knowledgeArticleConfiguration(block: aws.sdk.kotlin.services.kendra.model.SalesforceKnowledgeArticleConfiguration.Builder.() -> kotlin.Unit) {
            this.knowledgeArticleConfiguration = aws.sdk.kotlin.services.kendra.model.SalesforceKnowledgeArticleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration] inside the given [block]
         */
        fun standardObjectAttachmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration.Builder.() -> kotlin.Unit) {
            this.standardObjectAttachmentConfiguration = aws.sdk.kotlin.services.kendra.model.SalesforceStandardObjectAttachmentConfiguration.invoke(block)
        }
    }
}
