// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to
 * ServiceNow as your data source.
 */
class ServiceNowConfiguration private constructor(builder: Builder) {
    /**
     * The type of authentication used to connect to the
     * ServiceNow instance. If you choose HTTP_BASIC, Amazon Kendra is
     * authenticated using the user name and password provided in the
     * Secrets Manager secret in the SecretArn field. When you
     * choose OAUTH2, Amazon Kendra is authenticated using the OAuth
     * token and secret provided in the Secrets Manager secret, and the
     * user name and password are used to determine which information Amazon Kendra
     * has access to.
     * When you use OAUTH2 authentication, you must generate
     * a token and a client secret using the ServiceNow console. For more
     * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
     * ServiceNow data source.
     */
    val authenticationType: aws.sdk.kotlin.services.kendra.model.ServiceNowAuthenticationType? = builder.authenticationType
    /**
     * The ServiceNow instance that the data source connects to. The host
     * endpoint should look like the following:
     * {instance}.service-now.com.
     */
    val hostUrl: kotlin.String? = builder.hostUrl
    /**
     * Configuration information for crawling knowledge articles
     * in the ServiceNow site.
     */
    val knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration? = builder.knowledgeArticleConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Secrets Manager secret
     * that contains the user name and password required to connect to the
     * ServiceNow instance.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * Configuration information for crawling service catalogs
     * in the ServiceNow site.
     */
    val serviceCatalogConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration? = builder.serviceCatalogConfiguration
    /**
     * The identifier of the release that the ServiceNow host is running.
     * If the host is not running the LONDON release, use
     * OTHERS.
     */
    val serviceNowBuildVersion: aws.sdk.kotlin.services.kendra.model.ServiceNowBuildVersionType? = builder.serviceNowBuildVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceNowConfiguration(")
        append("authenticationType=$authenticationType,")
        append("hostUrl=$hostUrl,")
        append("knowledgeArticleConfiguration=$knowledgeArticleConfiguration,")
        append("secretArn=$secretArn,")
        append("serviceCatalogConfiguration=$serviceCatalogConfiguration,")
        append("serviceNowBuildVersion=$serviceNowBuildVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (hostUrl?.hashCode() ?: 0)
        result = 31 * result + (knowledgeArticleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (serviceCatalogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceNowBuildVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceNowConfiguration

        if (authenticationType != other.authenticationType) return false
        if (hostUrl != other.hostUrl) return false
        if (knowledgeArticleConfiguration != other.knowledgeArticleConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (serviceCatalogConfiguration != other.serviceCatalogConfiguration) return false
        if (serviceNowBuildVersion != other.serviceNowBuildVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of authentication used to connect to the
         * ServiceNow instance. If you choose HTTP_BASIC, Amazon Kendra is
         * authenticated using the user name and password provided in the
         * Secrets Manager secret in the SecretArn field. When you
         * choose OAUTH2, Amazon Kendra is authenticated using the OAuth
         * token and secret provided in the Secrets Manager secret, and the
         * user name and password are used to determine which information Amazon Kendra
         * has access to.
         * When you use OAUTH2 authentication, you must generate
         * a token and a client secret using the ServiceNow console. For more
         * information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html">Using a
         * ServiceNow data source.
         */
        var authenticationType: aws.sdk.kotlin.services.kendra.model.ServiceNowAuthenticationType? = null
        /**
         * The ServiceNow instance that the data source connects to. The host
         * endpoint should look like the following:
         * {instance}.service-now.com.
         */
        var hostUrl: kotlin.String? = null
        /**
         * Configuration information for crawling knowledge articles
         * in the ServiceNow site.
         */
        var knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret
         * that contains the user name and password required to connect to the
         * ServiceNow instance.
         */
        var secretArn: kotlin.String? = null
        /**
         * Configuration information for crawling service catalogs
         * in the ServiceNow site.
         */
        var serviceCatalogConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration? = null
        /**
         * The identifier of the release that the ServiceNow host is running.
         * If the host is not running the LONDON release, use
         * OTHERS.
         */
        var serviceNowBuildVersion: aws.sdk.kotlin.services.kendra.model.ServiceNowBuildVersionType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration) : this() {
            this.authenticationType = x.authenticationType
            this.hostUrl = x.hostUrl
            this.knowledgeArticleConfiguration = x.knowledgeArticleConfiguration
            this.secretArn = x.secretArn
            this.serviceCatalogConfiguration = x.serviceCatalogConfiguration
            this.serviceNowBuildVersion = x.serviceNowBuildVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = ServiceNowConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration] inside the given [block]
         */
        fun knowledgeArticleConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration.Builder.() -> kotlin.Unit) {
            this.knowledgeArticleConfiguration = aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration] inside the given [block]
         */
        fun serviceCatalogConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceCatalogConfiguration = aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration.invoke(block)
        }
    }
}
