// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for crawling service catalog
 * items in the ServiceNow site
 */
class ServiceNowServiceCatalogConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether Amazon Kendra should crawl attachments to the service
     * catalog items.
     */
    val crawlAttachments: kotlin.Boolean = builder.crawlAttachments
    /**
     * The name of the ServiceNow field that is mapped to the index
     * document contents field in the Amazon Kendra index.
     */
    val documentDataFieldName: kotlin.String? = builder.documentDataFieldName
    /**
     * The name of the ServiceNow field that is mapped to the index
     * document title field.
     */
    val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * A list of regular expression patterns to exclude certain attachments of catalogs in
     * your ServiceNow. Item that match the patterns are excluded from the index. Items that
     * don't match the patterns are included in the index. If an item matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * item isn't included in the index.
     * The regex is applied to the file name of the attachment.
     */
    val excludeAttachmentFilePatterns: List<String>? = builder.excludeAttachmentFilePatterns
    /**
     * Maps attributes or field names of catalogs to Amazon Kendra index
     * field names. To create custom fields, use the UpdateIndex API before
     * you map to ServiceNow fields.
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields.
     * The ServiceNow data source field names must exist in your ServiceNow custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain attachments of catalogs in
     * your ServiceNow. Item that match the patterns are included in the index. Items that
     * don't match the patterns are excluded from the index. If an item matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * item isn't included in the index.
     * The regex is applied to the file name of the attachment.
     */
    val includeAttachmentFilePatterns: List<String>? = builder.includeAttachmentFilePatterns

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceNowServiceCatalogConfiguration(")
        append("crawlAttachments=$crawlAttachments,")
        append("documentDataFieldName=$documentDataFieldName,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("excludeAttachmentFilePatterns=$excludeAttachmentFilePatterns,")
        append("fieldMappings=$fieldMappings,")
        append("includeAttachmentFilePatterns=$includeAttachmentFilePatterns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crawlAttachments.hashCode()
        result = 31 * result + (documentDataFieldName?.hashCode() ?: 0)
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (excludeAttachmentFilePatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (includeAttachmentFilePatterns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceNowServiceCatalogConfiguration

        if (crawlAttachments != other.crawlAttachments) return false
        if (documentDataFieldName != other.documentDataFieldName) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (excludeAttachmentFilePatterns != other.excludeAttachmentFilePatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (includeAttachmentFilePatterns != other.includeAttachmentFilePatterns) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether Amazon Kendra should crawl attachments to the service
         * catalog items.
         */
        var crawlAttachments: kotlin.Boolean = false
        /**
         * The name of the ServiceNow field that is mapped to the index
         * document contents field in the Amazon Kendra index.
         */
        var documentDataFieldName: kotlin.String? = null
        /**
         * The name of the ServiceNow field that is mapped to the index
         * document title field.
         */
        var documentTitleFieldName: kotlin.String? = null
        /**
         * A list of regular expression patterns to exclude certain attachments of catalogs in
         * your ServiceNow. Item that match the patterns are excluded from the index. Items that
         * don't match the patterns are included in the index. If an item matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * item isn't included in the index.
         * The regex is applied to the file name of the attachment.
         */
        var excludeAttachmentFilePatterns: List<String>? = null
        /**
         * Maps attributes or field names of catalogs to Amazon Kendra index
         * field names. To create custom fields, use the UpdateIndex API before
         * you map to ServiceNow fields.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields.
         * The ServiceNow data source field names must exist in your ServiceNow custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain attachments of catalogs in
         * your ServiceNow. Item that match the patterns are included in the index. Items that
         * don't match the patterns are excluded from the index. If an item matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * item isn't included in the index.
         * The regex is applied to the file name of the attachment.
         */
        var includeAttachmentFilePatterns: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration) : this() {
            this.crawlAttachments = x.crawlAttachments
            this.documentDataFieldName = x.documentDataFieldName
            this.documentTitleFieldName = x.documentTitleFieldName
            this.excludeAttachmentFilePatterns = x.excludeAttachmentFilePatterns
            this.fieldMappings = x.fieldMappings
            this.includeAttachmentFilePatterns = x.includeAttachmentFilePatterns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration = ServiceNowServiceCatalogConfiguration(this)
    }
}
