// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Microsoft
 * SharePoint as your data source.
 */
class SharePointConfiguration private constructor(builder: Builder) {
    /**
     * TRUE to include attachments to documents stored in
     * your Microsoft SharePoint site in the index; otherwise,
     * FALSE.
     */
    val crawlAttachments: kotlin.Boolean = builder.crawlAttachments
    /**
     * A Boolean value that specifies whether local
     * groups are disabled (True) or enabled (False).
     */
    val disableLocalGroups: kotlin.Boolean = builder.disableLocalGroups
    /**
     * The Microsoft SharePoint attribute field that contains the title
     * of the document.
     */
    val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * A list of regular expression patterns to exclude certain documents in your SharePoint.
     * Documents that match the patterns are excluded from the index. Documents that
     * don't match the patterns are included in the index. If a document matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * document isn't included in the index.
     * The regex is applied to the display URL of the SharePoint
     * document.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of DataSourceToIndexFieldMapping objects that map SharePoint data
     * source attributes or field names to Amazon Kendra index field names. To create
     * custom fields, use the UpdateIndex API before you map to SharePoint fields.
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields.
     * The SharePoint data source field names must exist in your SharePoint custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain documents in your SharePoint.
     * Documents that match the patterns are included in the index. Documents that
     * don't match the patterns are excluded from the index. If a document matches both
     * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
     * document isn't included in the index.
     * The regex is applied to the display URL of the SharePoint
     * document.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The Amazon Resource Name (ARN) of credentials stored in
     * Secrets Manager. The credentials should be a user/password pair.
     * If you use SharePoint Server, you also need to provide the sever
     * domain name as part of the credentials. For
     * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
     * Microsoft SharePoint Data Source. For more information
     * about Secrets Manager see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
     * Secrets Manager in the Secrets Manager
     * user guide.
     */
    val secretArn: kotlin.String? = builder.secretArn
    /**
     * The version of Microsoft SharePoint that you are using as a data
     * source.
     */
    val sharePointVersion: aws.sdk.kotlin.services.kendra.model.SharePointVersion? = builder.sharePointVersion
    /**
     * Information required to find a specific file in an Amazon S3
     * bucket.
     */
    val sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sslCertificateS3Path
    /**
     * The URLs of the Microsoft SharePoint site that contains the
     * documents that should be indexed.
     */
    val urls: List<String>? = builder.urls
    /**
     * TRUE to use the SharePoint change log to determine which documents
     * require updating in the index. Depending on the change log's
     * size, it may take longer for Amazon Kendra to use the change log than to
     * scan all of your documents in SharePoint.
     */
    val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Provides the configuration information to connect to an Amazon VPC.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SharePointConfiguration(")
        append("crawlAttachments=$crawlAttachments,")
        append("disableLocalGroups=$disableLocalGroups,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("secretArn=$secretArn,")
        append("sharePointVersion=$sharePointVersion,")
        append("sslCertificateS3Path=$sslCertificateS3Path,")
        append("urls=$urls,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crawlAttachments.hashCode()
        result = 31 * result + (disableLocalGroups.hashCode())
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sharePointVersion?.hashCode() ?: 0)
        result = 31 * result + (sslCertificateS3Path?.hashCode() ?: 0)
        result = 31 * result + (urls?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SharePointConfiguration

        if (crawlAttachments != other.crawlAttachments) return false
        if (disableLocalGroups != other.disableLocalGroups) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (secretArn != other.secretArn) return false
        if (sharePointVersion != other.sharePointVersion) return false
        if (sslCertificateS3Path != other.sslCertificateS3Path) return false
        if (urls != other.urls) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * TRUE to include attachments to documents stored in
         * your Microsoft SharePoint site in the index; otherwise,
         * FALSE.
         */
        var crawlAttachments: kotlin.Boolean = false
        /**
         * A Boolean value that specifies whether local
         * groups are disabled (True) or enabled (False).
         */
        var disableLocalGroups: kotlin.Boolean = false
        /**
         * The Microsoft SharePoint attribute field that contains the title
         * of the document.
         */
        var documentTitleFieldName: kotlin.String? = null
        /**
         * A list of regular expression patterns to exclude certain documents in your SharePoint.
         * Documents that match the patterns are excluded from the index. Documents that
         * don't match the patterns are included in the index. If a document matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * The regex is applied to the display URL of the SharePoint
         * document.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that map SharePoint data
         * source attributes or field names to Amazon Kendra index field names. To create
         * custom fields, use the UpdateIndex API before you map to SharePoint fields.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping data source fields.
         * The SharePoint data source field names must exist in your SharePoint custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain documents in your SharePoint.
         * Documents that match the patterns are included in the index. Documents that
         * don't match the patterns are excluded from the index. If a document matches both
         * an inclusion and exclusion pattern, the exclusion pattern takes precedence and the
         * document isn't included in the index.
         * The regex is applied to the display URL of the SharePoint
         * document.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of credentials stored in
         * Secrets Manager. The credentials should be a user/password pair.
         * If you use SharePoint Server, you also need to provide the sever
         * domain name as part of the credentials. For
         * more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html">Using a
         * Microsoft SharePoint Data Source. For more information
         * about Secrets Manager see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html"> What Is
         * Secrets Manager in the Secrets Manager
         * user guide.
         */
        var secretArn: kotlin.String? = null
        /**
         * The version of Microsoft SharePoint that you are using as a data
         * source.
         */
        var sharePointVersion: aws.sdk.kotlin.services.kendra.model.SharePointVersion? = null
        /**
         * Information required to find a specific file in an Amazon S3
         * bucket.
         */
        var sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * The URLs of the Microsoft SharePoint site that contains the
         * documents that should be indexed.
         */
        var urls: List<String>? = null
        /**
         * TRUE to use the SharePoint change log to determine which documents
         * require updating in the index. Depending on the change log's
         * size, it may take longer for Amazon Kendra to use the change log than to
         * scan all of your documents in SharePoint.
         */
        var useChangeLog: kotlin.Boolean = false
        /**
         * Provides the configuration information to connect to an Amazon VPC.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SharePointConfiguration) : this() {
            this.crawlAttachments = x.crawlAttachments
            this.disableLocalGroups = x.disableLocalGroups
            this.documentTitleFieldName = x.documentTitleFieldName
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.secretArn = x.secretArn
            this.sharePointVersion = x.sharePointVersion
            this.sslCertificateS3Path = x.sslCertificateS3Path
            this.urls = x.urls
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SharePointConfiguration = SharePointConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        fun sslCertificateS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sslCertificateS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
